/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.JCoTraceListener;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.SyncDateFormat;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;

public class ErrorTrace
extends Trace
implements JCoTraceListener {
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private static final SyncDateFormat fileNameTimestampFormat = new SyncDateFormat("yyyyMMdd_HHmmss");
    private static int traceLevel = 1;
    private static ErrorTrace errorTrace = null;
    private static Writer traceWriter = null;
    private static File traceFile = null;
    private static Object mutex = new Object();
    private static JCoTraceListener singleton = null;
    private static String traceFileName = "dev_jco.trc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        traceLevel = System.getProperty("jco.error_trace", "1").equals("1") ? 1 : 0;
        Class<ErrorTrace> clazz = ErrorTrace.class;
        synchronized (ErrorTrace.class) {
            if (singleton == null) {
                singleton = new ErrorTrace();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (traceLevel == 0) {
                Trace.removeTraceListener(singleton);
            } else {
                Trace.addTracelistener(singleton);
                if (!Trace.isOn(2, true)) {
                    Trace.setJCoTrace(1);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer getTraceWriter() {
        Object object = mutex;
        synchronized (object) {
            if (errorTrace == null) {
                errorTrace = new ErrorTrace();
                traceFile = new File(traceFileName);
                traceWriter = ErrorTrace.openFile(traceFile);
                ErrorTrace.writeInfo(errorTrace);
            }
            if (traceWriter == null) {
                traceWriter = ErrorTrace.openFile(traceFile);
            }
        }
        return traceWriter;
    }

    private static Writer openFile(File file) {
        OutputStreamWriter writer = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file, true);
                writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
                fos.flush();
            }
            catch (UnsupportedEncodingException e) {
                writer = new OutputStreamWriter(new FileOutputStream(file));
            }
            return writer;
        }
        catch (IOException ex) {
            throw new RuntimeException("JCO-TraceWriter: cannot open trace file [" + file.getAbsolutePath() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int level, String message) {
        if (level > traceLevel) {
            return;
        }
        try {
            Object object = mutex;
            synchronized (object) {
                traceWriter = this.getTraceWriter();
                if (traceWriter != null && traceFile.length() > 0x1400000L) {
                    traceWriter.close();
                    String renameToName = new StringBuilder(50).append(traceFileName.substring(0, traceFileName.lastIndexOf(46))).append('.').append(fileNameTimestampFormat.format(new Date())).append(".trc").toString();
                    traceFile.renameTo(new File(renameToName));
                    traceWriter = ErrorTrace.openFile(traceFile);
                }
                traceWriter.write(Thread.currentThread().getName());
                traceWriter.write(" [");
                traceWriter.write(timeStamp.format(new Date()));
                traceWriter.write("]");
                traceWriter.write(": ");
                traceWriter.write(message);
                traceWriter.write(CRLF);
                traceWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

