/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RfcDestinationMonitor
implements JCoDestinationMonitor {
    private ClientFactory clientFactory = null;

    RfcDestinationMonitor(String destinationID) {
        ConnectionManager cm = ConnectionManager.getConnectionManager();
        this.clientFactory = cm.getFactoryByDestinationID(destinationID);
        if (this.clientFactory == null) {
            throw new JCoRuntimeException(120, "JCO_ERROR_EXTENSION", "destination with " + destinationID + " isn't initialized or is already removed");
        }
    }

    @Override
    public long getLastActivityTimestamp() {
        return this.clientFactory.getLastActivityTimestamp();
    }

    @Override
    public int getMaxUsedCount() {
        return this.clientFactory.getMaxUsed();
    }

    @Override
    public int getPeakLimit() {
        return this.clientFactory.getPeakLimit();
    }

    @Override
    public int getPoolCapacity() {
        return this.clientFactory.getCapacity();
    }

    @Override
    public int getPooledConnectionCount() {
        return this.clientFactory.getPooledConnectionCount();
    }

    @Override
    public int getUsedConnectionCount() {
        return this.clientFactory.getNumUsed();
    }

    @Override
    public List<? extends JCoConnectionData> getConnectionsData() {
        ArrayList<MonitoredConnectionData> monitoredData = new ArrayList<MonitoredConnectionData>();
        this.clientFactory.getMonitoredData(monitoredData);
        return monitoredData;
    }

    @Override
    public String getDestinationID() {
        return this.clientFactory.getDestinationID();
    }

    @Override
    public String getOriginDestinationID() {
        return this.clientFactory.getOriginDestinationID();
    }
}

