/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.DestinationBack;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.RfcDestinationMonitor;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.i18n.cp.ConvertXToC;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDestinationManager
extends JCoDestinationManager
implements DestinationDataEventListener {
    private static final int REMOVE_OLD = 1;
    private static final int CREATE_NEW = 2;
    private static final int UPDATE_OLD = 4;
    private static final int CHANGE_REP = 8;
    private static final int NOT_FOUND = 16;
    private DestinationBack backDestination = new DestinationBack();
    Hashtable<String, RfcDestination> destinations = new Hashtable(29);
    private DestinationDataProvider provider;
    private int isCurrentUserIdSupported = -1;
    private JCoRuntime runtime = JCoRuntimeFactory.getRuntime();

    DefaultDestinationManager(DestinationDataProvider destinationProvider) {
        this.updateDestinationDataProvider(destinationProvider);
    }

    final void updateDestinationDataProvider(DestinationDataProvider destinationProvider) {
        if (destinationProvider != null) {
            this.provider = destinationProvider;
            this.isCurrentUserIdSupported = -1;
            if (destinationProvider.supportsEvents()) {
                destinationProvider.setDestinationDataEventListener(this);
            }
            ArrayList<String> cachedDestNames = new ArrayList<String>();
            cachedDestNames.addAll(this.destinations.keySet());
            for (String cachedDestName : cachedDestNames) {
                try {
                    this.update(cachedDestName, this.destinations.get(cachedDestName));
                }
                catch (JCoException e) {
                    if (e.getGroup() == 106) {
                        this.deleted(cachedDestName);
                        continue;
                    }
                    Trace.fireTraceCritical("[JCoAPI] exception during update of cached destination", e);
                }
            }
        }
    }

    @Override
    public JCoDestination getDestinationInstance(String destinationName, String scopeType) throws JCoException {
        if (Trace.isOn(2, true) && Trace.isOn(16)) {
            Trace.fireTrace(16, "[JCoAPI] DefaultDestinationManager.getDestinationInstance(" + (destinationName == null ? "null" : destinationName) + ") calls on provider " + (this.provider == null ? "null" : this.provider.getClass().getName()));
        }
        if (destinationName == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "Destination name is null when looking up a destination. Please specify a destination name.");
        }
        if (destinationName.equals("BACK")) {
            return this.backDestination;
        }
        return this.searchDestination(destinationName, scopeType);
    }

    @Override
    public void deleted(String destinationName) {
        if (Trace.isOn(64, true)) {
            Trace.fireTrace(64, "[JCoAPI] DefaultDestinationManager got event deleted for destination " + (destinationName == null ? "null" : destinationName) + ") ");
        }
        this.removeFromCache(destinationName, true);
    }

    private void removeFromCache(String destinationName, boolean wasDeleted) {
        InternalDestination cachedDestination = this.destinations.remove(destinationName);
        if (cachedDestination instanceof RfcDestination) {
            RfcDestination destination = (RfcDestination)cachedDestination;
            ConnectionManager.getConnectionManager().removeFactory(destination);
            this.runtime.getRepositoryManager().releaseRepository(destination);
            destination.resetRepository();
            if (wasDeleted) {
                destination.markDeleted();
            } else {
                destination.markChanged();
            }
        }
    }

    @Override
    public void updated(String destinationName) {
        if (Trace.isOn(64, true)) {
            Trace.fireTrace(64, "[JCoAPI] DefaultDestinationManager got event updated for destination " + (destinationName == null ? "null" : destinationName) + ") ");
        }
        try {
            RfcDestination destination = this.destinations.get(destinationName);
            if (destination != null && (destination = this.update(destinationName, destination)) == null) {
                Trace.fireTrace(8, "[JCoAPI] Destination Provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " returned null on update of destination " + destinationName + " destination");
            }
        }
        catch (JCoException e) {
            Trace.fireTraceCritical("[JCoAPI] DestinationDataEventListener.updated(" + destinationName + ") called on provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " throws exception:" + e.toString());
        }
    }

    private RfcDestination update(String destinationName, RfcDestination destination) throws JCoException {
        Properties properties = null;
        Throwable destinationProvidersException = null;
        try {
            properties = this.getProperties(destinationName);
        }
        catch (JCoRuntimeException jex) {
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, "[JCoAPI] DefaultDestinationManager.getDestinationInstance(" + destinationName + ") called on provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " returned invalid configuration", destinationProvidersException);
            }
            throw jex;
        }
        catch (Throwable th) {
            destinationProvidersException = th;
        }
        if (destination == null) {
            if (properties == null) {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, "[JCoAPI] DefaultDestinationManager.getDestinationInstance(" + destinationName + ") called on provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " returned null on update", destinationProvidersException);
                }
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Destination " + destinationName + " does not exist", destinationProvidersException);
            }
            if (Trace.isOn(32)) {
                StringBuilder buffer = new StringBuilder(100);
                buffer.append("[JCoAPI] DestinationManager.searchDestination(").append(destinationName);
                buffer.append(") CREATE_NEW");
                Trace.fireTrace(32, buffer.toString());
            }
            destination = new RfcDestination(destinationName, properties, this.provider.getClass().getName());
            this.destinations.put(destinationName, destination);
        } else {
            int comp = this.compare(destination, properties);
            if (Trace.isOn(32)) {
                StringBuilder buffer = new StringBuilder(100);
                buffer.append("[JCoAPI] DestinationManager.searchDestination(").append(destinationName).append(") got from provider ").append(this.provider == null ? "null" : this.provider.getClass().getName());
                if ((comp & 1) != 0) {
                    buffer.append(" REMOVE_OLD");
                }
                if ((comp & 0x10) != 0) {
                    buffer.append(" NOT_FOUND");
                }
                if ((comp & 2) != 0) {
                    buffer.append(" CREATE_NEW");
                }
                if ((comp & 4) != 0) {
                    buffer.append(" UPDATE_OLD");
                }
                if ((comp & 8) != 0) {
                    buffer.append(" CHANGE_REP");
                }
                if ((comp & 0x1F) == 0) {
                    buffer.append(" NO ACTION - properties are not changed");
                }
                Trace.fireTrace(32, buffer.toString());
            }
            if ((comp & 1) != 0) {
                if ((comp & 0x10) != 0) {
                    this.deleted(destinationName);
                    if (Trace.isOn(144)) {
                        Trace.fireTrace(144, "[JCoAPI] DefaultDestinationManager.getDestinationInstance(" + destinationName + ") called on provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " returned null");
                    }
                    throw new JCoException(106, "JCO_ERROR_RESOURCE", "Destination " + destinationName + " does not exist", destinationProvidersException);
                }
                if ((comp & 2) != 0) {
                    this.removeFromCache(destinationName, false);
                    destination = new RfcDestination(destinationName, properties, this.provider.getClass().getName());
                    this.destinations.put(destinationName, destination);
                }
            } else {
                if ((comp & 4) != 0) {
                    ClientFactory factory = ConnectionManager.getConnectionManager().getFactory(destination, false, false);
                    ClientFactory factoryRepo = ConnectionManager.getConnectionManager().getFactory(destination, true, false);
                    destination.setProperties(properties, this.provider.getClass().getName());
                    if (factory != null) {
                        factory.updateDestination(destination);
                    }
                    if (factoryRepo != null) {
                        factoryRepo.updateDestination(destination);
                    }
                }
                if ((comp & 8) != 0) {
                    this.runtime.getRepositoryManager().releaseRepository(destination);
                    destination.resetRepository();
                }
            }
        }
        return destination;
    }

    private Properties getProperties(String destinationName) throws JCoRuntimeException {
        Properties properties = this.provider.getDestinationProperties(destinationName);
        if (Trace.isOn(64)) {
            StringBuilder buf = Trace.bufferForConnectionProperties(properties);
            Trace.fireTrace(64, "[JCoAPI] DefaultDestinationManager.getDestinationInstance(" + destinationName + ") got from provider " + (this.provider == null ? "null" : this.provider.getClass().getName()) + " the following properties: " + buf.toString());
        }
        if (properties != null) {
            properties = this.checkAndCopyProperties(destinationName, properties);
        }
        return properties;
    }

    protected JCoDestination searchDestination(String destinationName, String scopeType) throws JCoException {
        RfcDestination destination = this.destinations.get(destinationName);
        if (this.provider == null) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, new FastStringBuffer().append("[JCoAPI] DefaultDestinationManager.getDestinationInstance(").append(destinationName).append(") called, but no provider is registered").append(destination == null ? " => throw JCO_ERROR_RESOURCE." : " => return a cached destination").toString());
            }
            if (destination == null) {
                throw new JCoException(106, "JCO_ERROR_RESOURCE", new FastStringBuffer(150).append("Destination ").append(destinationName).append(" cannot be created, because no destination provider is installed").toString());
            }
        } else if (destination == null || !this.provider.supportsEvents()) {
            destination = this.update(destinationName, destination);
        }
        if (destination.withCurrentUser) {
            Properties currentP = this.isCurrentUserIdSupported == 0 ? destination.properties : this.getProperties(destinationName);
            destination = new RfcDestination(destinationName, currentP, "destination for the current user ", destination);
        }
        if (scopeType != null && scopeType.length() > 0) {
            destination = destination.getDestinationForScope(scopeType);
        }
        return destination;
    }

    private int compare(RfcDestination cacheddestination, Properties last) {
        int result = 0;
        if (last == null) {
            result |= 0x11;
        } else {
            Properties cached = cacheddestination.properties;
            if (!(this.isPropertyValueEqual("jco.client.type", last, cached) && this.isPropertyValueEqual("jco.client.saprouter", last, cached) && this.isPropertyValueEqual("jco.client.sysnr", last, cached) && this.isPropertyValueEqual("jco.client.ashost", last, cached) && this.isPropertyValueEqual("jco.client.mshost", last, cached) && this.isPropertyValueEqual("jco.client.msserv", last, cached) && this.isPropertyValueEqual("jco.client.gwhost", last, cached) && this.isPropertyValueEqual("jco.client.gwserv", last, cached) && this.isPropertyValueEqual("jco.client.r3name", last, cached) && this.isPropertyValueEqual("jco.client.group", last, cached) && this.isPropertyValueEqual("jco.client.r3name", last, cached) && this.isPropertyValueEqual("jco.client.dest", last, cached) && this.isPropertyValueEqual("jco.client.tphost", last, cached) && this.isPropertyValueEqual("jco.client.tpname", last, cached) && this.isPropertyValueEqual("jco.client.trace", last, cached) && this.isPropertyValueEqual("jco.client.client", last, cached) && this.isPropertyValueEqual("jco.client.user", last, cached) && this.isPropertyValueEqual("jco.client.alias_user", last, cached) && this.isPropertyValueEqual("jco.client.lang", last, cached) && this.isPropertyValueEqual("jco.destination.repository.passwd", last, cached) && this.isPropertyValueEqual("jco.destination.repository.user", last, cached) && this.isPropertyValueEqual("jco.client.codepage", last, cached) && this.isPropertyValueEqual("jco.client.cpic_trace", last, cached) && this.isPropertyValueEqual("jco.client.pcs", last, cached) && this.isPropertyValueEqual("jco.client.passwd", last, cached) && this.isPropertyValueEqual("jco.client.x509cert", last, cached) && this.isPropertyValueEqual("jco.client.snc_partnername", last, cached) && this.isPropertyValueEqual("jco.client.snc_qop", last, cached) && this.isPropertyValueEqual("jco.client.snc_myname", last, cached) && this.isPropertyValueEqual("jco.client.snc_mode", last, cached) && this.isPropertyValueEqual("jco.client.snc_lib", last, cached) && this.isPropertyValueEqual("CONFIGURED_USER", last, cached))) {
                result |= 3;
            }
            if (result != 0) {
                return result;
            }
            if (!(!"CONFIGURED_USER".equals(cached.getProperty("jco.destination.auth_type")) || this.isPropertyValueEqual("jco.client.mysapsso2", last, cached) && this.isPropertyValueEqual("jco.client.x509cert", last, cached))) {
                result |= 3;
            }
            if (result != 0) {
                return result;
            }
            if (!(this.isPropertyValueEqual("jco.client.lcheck", last, cached) && this.isPropertyValueEqual("jco.destination.peak_limit", last, cached) && this.isPropertyValueEqual("jco.destination.pool_capacity", last, cached) && this.isPropertyValueEqual("jco.destination.expiration_time", last, cached) && this.isPropertyValueEqual("jco.destination.expiration_check_period", last, cached) && this.isPropertyValueEqual("jco.destination.max_get_client_time", last, cached) && this.isPropertyValueEqual("jco.destination.repository.snc_mode", last, cached) && this.isPropertyValueEqual("jco.destination.max_get_client_time", last, cached))) {
                result |= 4;
            }
            if (!this.isPropertyValueEqual("jco.destination.repository_destination", last, cached)) {
                result |= 8;
            }
        }
        return result;
    }

    private boolean isPropertyValueEqual(String key, Properties cached, Properties actual) {
        String actualValue = actual.getProperty(key);
        String cachedValue = cached.getProperty(key);
        return cachedValue == actualValue || cachedValue != null && cachedValue.equals(actualValue);
    }

    protected Properties checkAndCopyProperties(String destinationName, Properties properties) throws JCoRuntimeException {
        Properties copied = (Properties)properties.clone();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = properties.get(key);
            copied.put(key, value.toString());
        }
        if (copied.getProperty("jco.client.idle_timeout", null) != null) {
            try {
                int idle_timeout = Integer.parseInt(copied.getProperty("jco.client.idle_timeout"));
                if (idle_timeout <= 0) {
                    throw new NumberFormatException("only positive values are allowed");
                }
            }
            catch (NumberFormatException ex) {
                throw new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid idle timeout [" + properties.getProperty("jco.client.idle_timeout") + "]: " + ex.getMessage() + " in the destination properties", ex);
            }
        }
        if (copied.getProperty("jco.destination.auth_type") == null) {
            this.isCurrentUserIdSupported = 1;
            if (Environment.inJStartup()) {
                if (copied.getProperty("jco.client.user") == null && copied.getProperty("jco.client.alias_user") == null) {
                    copied.setProperty("jco.destination.auth_type", "CURRENT_USER");
                } else {
                    copied.setProperty("jco.destination.auth_type", "CONFIGURED_USER");
                }
            } else {
                copied.setProperty("jco.destination.auth_type", "CONFIGURED_USER");
            }
        }
        if (this.isCurrentUserIdSupported == -1 && copied.getProperty("jco.client.user") == null && copied.getProperty("jco.client.alias_user") == null) {
            this.isCurrentUserIdSupported = copied.getProperty("jco.destination.user_id") != null ? 0 : 1;
        }
        DefaultDestinationManager.getUserId(destinationName, copied, false);
        return copied;
    }

    @Override
    public final List<String> getDestinationIDs() {
        ConnectionManager connMan = ConnectionManager.getConnectionManager();
        List<ClientFactory> factories = connMan.getCopyOfAllFactories();
        ArrayList<String> destIDs = new ArrayList<String>();
        for (ClientFactory cf : factories) {
            if (cf.repositoryFactory) continue;
            destIDs.add(cf.getDestinationID());
        }
        return destIDs;
    }

    @Override
    public final List<String> getCustomDestinationIDs(String destinationID) {
        if (destinationID != null) {
            ArrayList<String> destIDs = new ArrayList<String>();
            ConnectionManager connMan = ConnectionManager.getConnectionManager();
            List<ClientFactory> factories = connMan.getCopyOfAllFactories();
            for (ClientFactory cf : factories) {
                if (!destinationID.equals(cf.originDestinationId) || destinationID.equals(cf.destinationId)) continue;
                destIDs.add(cf.getDestinationID());
            }
            return destIDs;
        }
        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "destination ID equals null is not allowed");
    }

    public final String getRepositoryDestinationID(String destinationID) {
        if (destinationID != null) {
            InternalDestination dest = this.getDestinationByID(destinationID);
            if (dest == null) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "destination ID " + destinationID + " does not exist");
            }
            String repKey = dest.getRepositoryKey();
            ConnectionManager connMan = ConnectionManager.getConnectionManager();
            List<ClientFactory> factories = connMan.getCopyOfAllFactories();
            for (ClientFactory cf : factories) {
                if (!repKey.equals(cf.originDestinationId)) continue;
                return cf.getDestinationID();
            }
            return null;
        }
        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "destination ID equals null is not allowed");
    }

    @Override
    public final JCoDestinationMonitor getDestinationMonitor(String destinationID) throws JCoRuntimeException {
        InternalDestination dest = this.getDestinationByID(destinationID);
        if (dest != null) {
            return dest.getMonitor();
        }
        return new RfcDestinationMonitor(destinationID);
    }

    @Override
    public final JCoDestinationMonitor getRepositoryDestinationMonitor(String destinationID) throws JCoRuntimeException {
        InternalDestination dest = this.getDestinationByID(destinationID);
        if (dest == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination with the ID " + destinationID + " is not available.");
        }
        return dest.getRepositoryDestinationMonitor();
    }

    final InternalDestination getDestinationByID(String destinationID) throws JCoRuntimeException {
        InternalDestination dest = null;
        ArrayList<String> destKeys = new ArrayList<String>(this.destinations.keySet());
        for (String destKey : destKeys) {
            dest = this.destinations.get(destKey);
            if (!dest.getDestinationID().equals(destinationID)) continue;
            return dest;
        }
        return null;
    }

    private static String getTicketIdentity(String base64encodedTicket) {
        byte[] ticketBytes = Codecs.Base64.decode(base64encodedTicket);
        String cp = null;
        try {
            cp = new String(ticketBytes, 1, 4, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        ConvertXToC conv = I18NConverters.getConvertXToC(cp);
        String userID = null;
        int id = 0;
        int len = 0;
        for (int off = 5; off < ticketBytes.length; off += len) {
            id = 0xFF & ticketBytes[off];
            len = (ticketBytes[++off] & 0xFF) << 8 | ticketBytes[off + 1] & 0xFF;
            off += 2;
            if (id != 1) continue;
            userID = new String(conv.ConvertArr(ticketBytes, off, off + len));
            break;
        }
        return userID;
    }

    static String getUserId(String destinationName, Properties props, boolean throwException) throws JCoRuntimeException {
        String userID = null;
        userID = props.getProperty("jco.client.user");
        if (userID == null && (userID = props.getProperty("jco.client.alias_user")) == null && (userID = props.getProperty("jco.destination.user_id")) == null) {
            userID = props.getProperty("jco.client.mysapsso2");
            if (userID != null) {
                try {
                    userID = DefaultDestinationManager.getTicketIdentity(userID);
                }
                catch (RuntimeException ex) {
                    JCoRuntimeException jex = new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid sso ticket encountered on " + destinationName + " [" + userID + "]");
                    if (Trace.isOn(8)) {
                        Trace.fireTrace(8, "[JCoAPI] " + jex.getMessage(), jex);
                    }
                    throw jex;
                }
                props.setProperty("jco.destination.user_id", userID);
            } else {
                userID = props.getProperty("jco.client.x509cert");
                if (userID != null && !Environment.inStandalone()) {
                    props.setProperty("jco.destination.user_id", userID);
                }
            }
        }
        if (userID == null && throwException && Environment.inStandalone()) {
            boolean isSncUsed = "1".equals(props.getProperty("jco.client.snc_mode"));
            JCoRuntimeException jex = new JCoRuntimeException(101, "JCO_ERROR_CONFIGURATION", "Invalid configuration on " + destinationName + ". " + (isSncUsed ? "Used ID is mandatory if neither user nor user alias are defined (see DestinationDataProvider.JCO_USER_ID)." : "User identity unknown: neither user nor logon ticket nor certificate is specified."));
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, "[JCoAPI] " + jex.getMessage(), true);
            }
            throw jex;
        }
        return userID;
    }
}

