/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultFieldIterator;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.XMLReader;
import com.sap.conn.jco.rt.XMLWriter;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.SyncDateFormat;
import com.sap.i18n.decfloat.DecFloat;
import com.sap.i18n.decfloat.DecFloatType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecord
implements Serializable,
JCoRecord,
Cloneable {
    static final long serialVersionUID = 3000120080918L;
    protected static final byte PARAMETER = 1;
    protected static final byte STRUCTURE = 2;
    protected static final byte TABLE = 4;
    protected static final byte SEGMENT = 8;
    protected static final byte REQUEST = 16;
    protected static final byte RESPONSE = 32;
    protected static final byte ABAPOBJECT = 64;
    protected byte recType = 1;
    public static final int UNINITIALIZED_PARAMETER = 1;
    protected AbstractMetaData metaData = null;
    protected char[] data = JCoRuntime.EMPTY_CHAR_ARRAY;
    protected char[][] tableDataRows = null;
    protected Object[] odata = JCoRuntime.EMPTY_OBJ_ARRAY;
    protected byte[] flags = JCoRuntime.EMPTY_BYTE_ARRAY;
    protected byte[] opcode = JCoRuntime.EMPTY_BYTE_ARRAY;
    protected int[] delta = null;
    protected int rowLength = 0;
    protected int numRows = 0;
    protected int row = 0;
    protected boolean modified = false;
    protected static final SyncDateFormat daterfc = new SyncDateFormat("yyyyMMdd");
    protected static final SyncDateFormat dateiso = new SyncDateFormat("yyyy-MM-dd");
    protected static final SyncDateFormat timerfc = new SyncDateFormat("HHmmss");
    protected static final SyncDateFormat timeiso = new SyncDateFormat("HH:mm:ss");

    AbstractRecord(int recType, JCoMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException(new StringBuilder(150).append("The metaData equals null is passed into Record").toString());
        }
        if (!metaData.isLocked()) {
            throw new IllegalArgumentException(new StringBuilder(150).append("The metaData is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.").toString());
        }
        if (metaData instanceof AbstractMetaData) {
            this.metaData = (AbstractMetaData)metaData;
        } else if (metaData instanceof JCoRecordMetaData) {
            this.metaData = new DefaultRecordMetaData((JCoRecordMetaData)metaData);
        } else if (metaData instanceof JCoListMetaData) {
            this.metaData = new DefaultListMetaData((JCoListMetaData)metaData);
        } else if (metaData instanceof JCoClassMetaData) {
            this.metaData = new DefaultClassMetaData((JCoClassMetaData)metaData);
        } else {
            throw new IllegalArgumentException(new StringBuilder(150).append("The metaData is neither instance of JCoRecordMetaData nor JCoListMetaData. ").append(metaData.getClass().getName()).append(" is passed into Record").toString());
        }
        this.recType = (byte)recType;
        this.numRows = this.recType == 4 ? 0 : 1;
        this.ensureBufferCapacity();
    }

    @Override
    public Object clone() {
        try {
            AbstractRecord obj = (AbstractRecord)super.clone();
            obj.copyContent(this);
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractRecord)) {
            return false;
        }
        AbstractRecord rec = (AbstractRecord)obj;
        if (!this.metaData.equals(rec.metaData)) {
            return false;
        }
        if (this.numRows != rec.numRows) {
            return false;
        }
        if (this.recType != rec.recType) {
            return false;
        }
        if (this.metaData.numOdata != rec.metaData.numOdata) {
            return false;
        }
        if (this.rowLength > 0) {
            for (int rowId = 0; rowId < this.numRows; ++rowId) {
                char[] d2;
                char[] d1;
                if (this.recType == 4) {
                    d1 = this.tableDataRows[rowId];
                    d2 = rec.tableDataRows[rowId];
                } else {
                    d1 = this.data;
                    d2 = rec.data;
                }
                for (int i = 0; i < this.rowLength; ++i) {
                    if (d1[i] == d2[i]) continue;
                    return false;
                }
            }
        }
        int size = this.numRows * this.metaData.numOdata;
        for (int i = 0; i < size; ++i) {
            if (this.odata[i] == null && rec.odata[i] == null) continue;
            if (this.odata[i] == null && rec.odata[i] != null || this.odata[i] != null && rec.odata[i] == null) {
                return false;
            }
            if (this.odata[i] instanceof AbstractRecord || this.odata[i] instanceof String) {
                if (this.odata[i].equals(rec.odata[i])) continue;
                return false;
            }
            if (this.odata[i] instanceof byte[]) {
                if (Arrays.equals((byte[])this.odata[i], (byte[])rec.odata[i])) continue;
                return false;
            }
            if (this.odata[i] == null) continue;
            Trace.fireTraceCritical(new StringBuilder(120).append("[JCoAPI] AbstractRecord.equals() Unknown object type inside JCoRecord:").append(this.odata[i].getClass().getName()).toString());
        }
        return true;
    }

    public int hashCode() {
        int hashcode = this.getMetaData().hashCode();
        if (this.rowLength > 0) {
            for (int rowId = 0; rowId < this.numRows; ++rowId) {
                char[] rowData = this.recType == 4 ? this.tableDataRows[rowId] : this.data;
                for (int i = 0; i < this.rowLength; ++i) {
                    hashcode = 31 * hashcode + rowData[i];
                }
            }
        }
        int size = this.numRows * this.metaData.numOdata;
        for (int i = 0; i < size; ++i) {
            if (this.odata[i] == null) continue;
            hashcode = 31 * hashcode + this.odata[i].hashCode();
        }
        return hashcode;
    }

    protected int getObjectId() {
        return System.identityHashCode(this);
    }

    protected void copyContent(AbstractRecord src) {
        int i;
        this.recType = src.recType;
        this.rowLength = src.rowLength;
        this.numRows = src.numRows;
        this.row = src.row;
        this.modified = src.modified;
        if (this.rowLength > 0) {
            if (src.tableDataRows != null) {
                this.tableDataRows = new char[src.tableDataRows.length][];
                for (i = 0; i < src.numRows; ++i) {
                    this.tableDataRows[i] = (char[])src.tableDataRows[i].clone();
                }
            } else if (src.data != null) {
                this.data = (char[])src.data.clone();
            }
        }
        if (src.delta != null) {
            this.delta = (int[])src.delta.clone();
        }
        if (src.opcode != null && src.opcode.length > 0) {
            this.opcode = (byte[])src.opcode.clone();
        }
        if (src.flags != null && src.flags.length > 0) {
            this.flags = (byte[])src.flags.clone();
        }
        if (src.odata != null && src.odata.length > 0) {
            this.odata = new Object[src.odata.length];
            for (i = 0; i < this.odata.length; ++i) {
                Object o = src.odata[i];
                if (o != null) {
                    if (o instanceof AbstractRecord) {
                        o = ((AbstractRecord)o).clone();
                    } else if (o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[i] = o;
            }
        }
    }

    protected ConversionException createConversionException(int index, String to_type) {
        return this.createConversionException(null, index, to_type);
    }

    protected ConversionException createConversionException(Throwable causedBy, int index, String to_type) {
        return new ConversionException(new StringBuilder(200).append("Cannot convert field ").append(this.metaData.name[index]).append(" of type ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" to ").append(to_type).toString(), causedBy);
    }

    protected ConversionException createConversionException(int index, String from_type, String value) {
        return this.createConversionException(null, index, from_type, value);
    }

    protected ConversionException createConversionException(Throwable causedBy, int index, String from_type, String value) {
        if (value != null) {
            return new ConversionException(new StringBuilder(200).append("Cannot convert a value of '").append(value).append("' from type ").append(from_type).append(" to ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" at field ").append(this.metaData.name[index]).toString(), causedBy);
        }
        return new ConversionException(new StringBuilder(200).append("Cannot convert a value from type ").append(from_type).append(" to ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" at field ").append(this.metaData.name[index]).toString());
    }

    protected void setModified(int row) {
        this.modified = true;
    }

    protected final boolean checkIfInitialized() {
        int i;
        boolean isInitialized = false;
        block4: for (i = 0; i < this.metaData.numFields; ++i) {
            switch (this.metaData.type[i]) {
                case 17: {
                    AbstractRecord rec = (AbstractRecord)this.odata[this.metaData.oindex[i]];
                    if (!rec.modified && !rec.checkIfInitialized()) continue block4;
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                    isInitialized = true;
                    continue block4;
                }
                case 99: {
                    AbstractRecord rec = (AbstractRecord)this.odata[this.metaData.oindex[i]];
                    if (!rec.modified) continue block4;
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                    isInitialized = true;
                    continue block4;
                }
            }
        }
        for (i = 0; i < this.metaData.numFields && !isInitialized; ++i) {
            isInitialized = (this.flags[i] & 1) == 0;
        }
        return isInitialized;
    }

    protected String getDefaultValue(int index) {
        return null;
    }

    protected DefaultTable createTable(DefaultRecordMetaData meta) {
        return new DefaultTable(meta);
    }

    protected void initializeRow(int irow) {
        int row_save = this.row;
        this.row = irow;
        String defval = null;
        char[] tmpData = null;
        if (this.rowLength > 0) {
            tmpData = this.recType == 4 ? this.tableDataRows[irow] : this.data;
        }
        block23: for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
            defval = this.getDefaultValue(ifield);
            switch (this.metaData.type[ifield]) {
                case 0: {
                    int i;
                    int istart = this.metaData.boffset[ifield];
                    int iend = istart + this.metaData.blength[ifield];
                    for (i = istart; i < iend; ++i) {
                        tmpData[i] = 32;
                    }
                    if (defval == null) continue block23;
                    int ioffset = this.metaData.boffset[ifield];
                    int ilength = Math.min(this.metaData.blength[ifield], defval.length());
                    defval.getChars(0, ilength, tmpData, ioffset);
                    continue block23;
                }
                case 17: {
                    if (this.odata.length <= 0 || !(this.metaData.tabMeta[ifield] instanceof JCoRecordMetaData)) continue block23;
                    DefaultStructure obj = new DefaultStructure((JCoRecordMetaData)this.metaData.tabMeta[ifield]);
                    this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[ifield]] = obj;
                    obj.ensureBufferCapacity();
                    continue block23;
                }
                case 99: {
                    if (this.odata.length <= 0 || !(this.metaData.tabMeta[ifield] instanceof JCoRecordMetaData)) continue block23;
                    DefaultTable obj = this.createTable((DefaultRecordMetaData)this.metaData.tabMeta[ifield]);
                    this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[ifield]] = obj;
                    obj.ensureBufferCapacity();
                    continue block23;
                }
                case 29: {
                    this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[ifield]] = defval;
                    continue block23;
                }
                case 30: {
                    this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[ifield]] = defval == null ? null : Codecs.Hex.decode(defval);
                    continue block23;
                }
                case 1: 
                case 3: 
                case 6: {
                    int i;
                    int istart = this.metaData.boffset[ifield];
                    int iend = istart + this.metaData.blength[ifield];
                    for (i = istart; i < iend; ++i) {
                        tmpData[i] = 48;
                    }
                    if (defval == null) continue block23;
                    int ioffset = this.metaData.boffset[ifield];
                    int ilength = Math.min(this.metaData.blength[ifield], defval.length());
                    defval.getChars(0, ilength, tmpData, ioffset);
                    continue block23;
                }
                case 8: 
                case 9: 
                case 10: {
                    if (defval == null) continue block23;
                    try {
                        this.encodeINT(Integer.parseInt(defval), ifield);
                    }
                    catch (Exception ex) {}
                    continue block23;
                }
                case 7: {
                    if (defval == null) continue block23;
                    try {
                        this.encodeFLOAT(Double.valueOf(defval), ifield);
                    }
                    catch (Exception ex) {}
                    continue block23;
                }
                case 2: {
                    if (defval != null) {
                        try {
                            this.encodeBCD(defval, ifield);
                        }
                        catch (Exception ex) {}
                        continue block23;
                    }
                    int ilength = this.metaData.length[0][ifield] * 2 - 1;
                    int n = this.metaData.boffset[ifield] + (ilength >> 2);
                    tmpData[n] = (char)(tmpData[n] | 12 << (3 - (ilength & 3) << 2));
                    continue block23;
                }
                case 23: {
                    boolean setDef;
                    boolean bl = setDef = defval != null;
                    if (setDef) {
                        try {
                            this.encodeDecFloat(new BigDecimal(defval, MathContext.DECIMAL64), ifield);
                        }
                        catch (Exception ex) {
                            setDef = false;
                        }
                    }
                    if (setDef) continue block23;
                    this.encodeBYTE(JCoRuntime.DECF16_ZERO, ifield);
                    continue block23;
                }
                case 24: {
                    boolean setDef;
                    boolean bl = setDef = defval != null;
                    if (setDef) {
                        try {
                            this.encodeDecFloat(new BigDecimal(defval, MathContext.DECIMAL128), ifield);
                        }
                        catch (Exception ex) {
                            setDef = false;
                        }
                    }
                    if (setDef) continue block23;
                    this.encodeBYTE(JCoRuntime.DECF34_ZERO, ifield);
                    continue block23;
                }
            }
        }
        this.row = row_save;
    }

    protected void ensureBufferCapacity() {
        Object[] old_odata = null;
        char[] old_data = null;
        boolean should_init = false;
        if (this.metaData.numFields > 0) {
            this.rowLength = this.metaData.boffset[this.metaData.numFields - 1] + this.metaData.blength[this.metaData.numFields - 1];
        }
        if (this.numRows == 0) {
            return;
        }
        if (this.odata == null || this.odata.length < this.metaData.numOdata) {
            if (this.odata != null && this.odata.length > 0) {
                old_odata = this.odata;
            }
            this.odata = new Object[this.metaData.numOdata];
            should_init = true;
        }
        if (this.data == null || this.data.length < this.rowLength) {
            if (this.data != null && this.data.length > 0) {
                old_data = this.data;
            }
            this.data = new char[this.rowLength];
            should_init = true;
        }
        if (should_init) {
            this.initializeRow(0);
            if (old_data != null && old_data.length > 0) {
                System.arraycopy(old_data, 0, this.data, 0, old_data.length);
            }
            if (old_odata != null && old_odata.length > 0) {
                System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
            }
        }
        if (this.flags.length < this.metaData.numFields) {
            byte[] newFlags = new byte[this.metaData.numFields];
            if (this.flags.length > 0) {
                System.arraycopy(this.flags, 0, newFlags, 0, this.flags.length);
            }
            this.flags = newFlags;
        }
    }

    protected final void checkRowCapacity() {
        if (this.recType == 4 && this.numRows == 0) {
            throw new IllegalStateException("Trying to access row values in a table which does not have any rows yet");
        }
    }

    @Override
    public void clear() {
        this.initializeRow(0);
        for (int i = 0; i < this.metaData.numFields; ++i) {
            try {
                if (this.metaData.type[i] == 99) {
                    this.getTable(i).clear();
                    continue;
                }
                if (this.metaData.type[i] != 17) continue;
                this.getStructure(i).clear();
                continue;
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyFrom(JCoRecord sourceRecord) {
        AbstractRecord source = (AbstractRecord)sourceRecord;
        if (source == null || source.metaData.numFields == 0 || source.numRows == 0) {
            return 0;
        }
        if (source.metaData.numFields == this.metaData.numFields) {
            boolean metadata_equals = true;
            for (int i = 0; i < source.metaData.numFields; ++i) {
                if (source.metaData.type[i] == this.metaData.type[i] && source.metaData.name[i] == this.metaData.name[i] && source.metaData.boffset[i] == this.metaData.boffset[i] && source.metaData.blength[i] == this.metaData.blength[i]) continue;
                metadata_equals = false;
                break;
            }
            if (metadata_equals) {
                int count;
                int src_idx;
                int dst_idx;
                boolean src_is_table;
                boolean dst_is_table = this.recType == 4;
                boolean bl = src_is_table = source.recType == 4;
                if (dst_is_table) {
                    ((JCoTable)((Object)this)).ensureBufferCapacity(this.numRows + source.numRows);
                } else {
                    this.ensureBufferCapacity();
                }
                if (this.rowLength > 0) {
                    if (dst_is_table) {
                        for (int i = 0; i < source.numRows; ++i) {
                            System.arraycopy(src_is_table ? source.tableDataRows[i] : source.data, 0, this.tableDataRows[this.numRows + i], 0, this.rowLength);
                        }
                    } else {
                        System.arraycopy(src_is_table ? source.tableDataRows[source.row] : source.data, source.metaData.boffset[0], this.data, this.metaData.boffset[0], source.rowLength);
                    }
                }
                if (dst_is_table) {
                    dst_idx = this.metaData.numOdata * this.numRows;
                    src_idx = 0;
                    count = source.numRows * source.metaData.numOdata;
                } else {
                    dst_idx = 0;
                    src_idx = source.row * source.metaData.numOdata;
                    count = this.metaData.numOdata;
                }
                int i = 0;
                while (i < count) {
                    if (source.odata[src_idx] != null) {
                        if (source.odata[src_idx] instanceof String) {
                            this.odata[dst_idx] = source.odata[src_idx];
                        } else if (source.odata[src_idx] instanceof AbstractRecord) {
                            this.odata[dst_idx] = ((AbstractRecord)source.odata[src_idx]).clone();
                        } else if (source.odata[src_idx] instanceof byte[]) {
                            this.odata[dst_idx] = ((byte[])source.odata[src_idx]).clone();
                        } else {
                            Trace.fireTraceCritical(new StringBuilder(120).append("[JCoAPI] JCoRecord.copyFrom() unknown type ").append(source.odata[src_idx].getClass().getName()).append(" in ").append(this.metaData.recName).toString());
                        }
                    }
                    ++i;
                    ++dst_idx;
                    ++src_idx;
                }
                this.numRows = dst_is_table ? this.numRows + source.numRows : 1;
                for (i = 0; i < this.metaData.numFields; ++i) {
                    if ((source.flags[i] & 1) != 0) {
                        int n = i;
                        this.flags[n] = (byte)(this.flags[n] | 1);
                        continue;
                    }
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                }
                this.modified = true;
                return this.metaData.numFields;
            }
        }
        int n = 0;
        int[] index = new int[source.metaData.numFields];
        int irow_save = source.row;
        int jrow_save = this.row;
        int jnum_rows_save = this.numRows;
        boolean modified_save = this.modified;
        char[] data_save = null;
        char[] temp_src_data = null;
        char[] temp_dst_data = null;
        Object table_data_rows_save = null;
        Object[] odata_save = null;
        byte[] opcode_save = null;
        byte[] flags_save = null;
        try {
            int j;
            int i;
            n = 0;
            block19: for (i = 0; i < source.metaData.numFields; ++i) {
                index[i] = -1;
                for (j = 0; j < this.metaData.numFields; ++j) {
                    if (source.metaData.type[i] != this.metaData.type[j] || !source.metaData.name[i].equals(this.metaData.name[j])) continue;
                    index[i] = j;
                    ++n;
                    continue block19;
                }
            }
            if (n == 0) {
                int n2 = n;
                return n2;
            }
            if (this.flags != null) {
                flags_save = new byte[this.flags.length];
                System.arraycopy(this.flags, 0, flags_save, 0, this.flags.length);
            }
            if (this.data != null) {
                data_save = new char[this.data.length];
                System.arraycopy(this.data, 0, data_save, 0, this.data.length);
            }
            if (this.tableDataRows != null) {
                table_data_rows_save = new char[this.tableDataRows.length][];
                System.arraycopy(this.tableDataRows, 0, table_data_rows_save, 0, this.tableDataRows.length);
            }
            if (this.odata != null) {
                odata_save = new Object[this.odata.length];
                System.arraycopy(this.odata, 0, odata_save, 0, this.odata.length);
            }
            if (this.opcode != null) {
                opcode_save = new byte[this.opcode.length];
                System.arraycopy(this.opcode, 0, opcode_save, 0, this.opcode.length);
            }
            if (this.recType == 4) {
                ((JCoTable)((Object)this)).ensureBufferCapacity(this.numRows + source.numRows);
                this.numRows += source.numRows;
            } else {
                this.ensureBufferCapacity();
            }
            for (i = 0; i < source.metaData.numFields; ++i) {
                j = index[i];
                if (j < 0) continue;
                this.row = this.recType == 4 ? jnum_rows_save : 0;
                byte itype = source.metaData.type[i];
                int ioffset = source.metaData.boffset[i];
                int ilength = source.metaData.blength[i];
                int joffset = this.metaData.boffset[j];
                int jlength = this.metaData.blength[j];
                ilength = Math.min(ilength, jlength);
                if ((source.flags[i] & 1) != 0) {
                    int n3 = j;
                    this.flags[n3] = (byte)(this.flags[n3] | 1);
                } else {
                    int n4 = j;
                    this.flags[n4] = (byte)(this.flags[n4] & 0xFFFFFFFE);
                }
                source.row = 0;
                while (source.row < source.numRows) {
                    if (this.rowLength > 0) {
                        temp_src_data = source.recType == 4 ? source.tableDataRows[source.row] : source.data;
                        temp_dst_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
                    }
                    switch (itype) {
                        case 0: {
                            int k;
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                            for (k = ilength; k < jlength; ++k) {
                                temp_dst_data[joffset + k] = 32;
                            }
                            break;
                        }
                        case 2: {
                            this.setValue(j, source.getBigDecimal(i));
                            break;
                        }
                        case 6: {
                            this.setValue(j, source.decodeNUM(i));
                            break;
                        }
                        case 4: {
                            int k;
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                            for (k = ilength; k < jlength; ++k) {
                                temp_dst_data[joffset + k] = '\u0000';
                            }
                            break;
                        }
                        case 17: {
                            DefaultStructure s = source.getStructure(i);
                            this.setValue(j, (JCoStructure)(s == null ? s : s.clone()));
                            break;
                        }
                        case 99: {
                            DefaultTable t = source.getTable(i);
                            this.setValue(j, (JCoTable)(t == null ? t : t.clone()));
                            break;
                        }
                        case 29: 
                        case 30: {
                            this.setValue(j, source.getValue(i));
                            break;
                        }
                        default: {
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                        }
                    }
                    ++this.row;
                    ++source.row;
                }
            }
            this.modified = true;
        }
        catch (Throwable t) {
            this.row = jrow_save;
            this.numRows = jnum_rows_save;
            this.data = data_save;
            this.tableDataRows = table_data_rows_save;
            this.odata = odata_save;
            this.opcode = opcode_save;
            this.flags = flags_save;
            this.modified = modified_save;
            source.row = irow_save;
        }
        finally {
            source.row = irow_save;
            this.row = jrow_save;
        }
        return n;
    }

    @Override
    public int getFieldCount() {
        return this.metaData.numFields;
    }

    @Override
    public AbstractMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Object getValue(int index) {
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: {
                return this.decodeCHAR(index);
            }
            case 8: 
            case 9: 
            case 10: {
                return new Integer(this.decodeINT(index));
            }
            case 7: {
                return new Double(this.decodeFLOAT(index));
            }
            case 6: {
                return this.decodeNUM(index);
            }
            case 2: {
                return new BigDecimal(this.decodeBCD(index));
            }
            case 23: 
            case 24: {
                return this.decodeDecFloat(index);
            }
            case 1: {
                return this.decodeDATE(index);
            }
            case 3: {
                return this.decodeTIME(index);
            }
            case 4: {
                return this.decodeBYTE(index);
            }
            case 29: {
                return this.decodeSTRING(index);
            }
            case 30: {
                return this.decodeXSTRING(index);
            }
            case 17: {
                return this.decodeSTRUCTURE(index);
            }
            case 99: {
                return this.decodeTABLE(index);
            }
            case 16: {
                return this.decodeABAPOBJECT(index, false);
            }
        }
        throw this.createConversionException(index, "object");
    }

    @Override
    public String getString(int index) {
        this.checkRowCapacity();
        if (this.metaData.getFieldCount() <= index) {
            throw new ArrayIndexOutOfBoundsException("record " + this.getMetaData().getName() + " has only " + this.metaData.getFieldCount() + " columns");
        }
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: {
                return this.decodeCHAR(index);
            }
            case 8: 
            case 9: 
            case 10: {
                return Integer.toString(this.decodeINT(index));
            }
            case 7: {
                return Double.toString(this.decodeFLOAT(index));
            }
            case 6: {
                return this.decodeNUM(index);
            }
            case 2: {
                return this.decodeBCD(index);
            }
            case 23: {
                byte[] value = this.decodeBYTE(index);
                return DecFloat.toPlainString(DecFloatType.DECFLOAT16_BE, value, 0, value.length);
            }
            case 24: {
                byte[] value = this.decodeBYTE(index);
                return DecFloat.toPlainString(DecFloatType.DECFLOAT34_BE, value, 0, value.length);
            }
            case 1: {
                String date = this.decodeCHAR(index);
                if (date != null && date.length() == 8) {
                    char[] buffer = new char[10];
                    date.getChars(0, 4, buffer, 0);
                    buffer[4] = 45;
                    date.getChars(4, 6, buffer, 5);
                    buffer[7] = 45;
                    date.getChars(6, 8, buffer, 8);
                    return new String(buffer);
                }
                return date;
            }
            case 3: {
                String time = this.decodeCHAR(index);
                if (time != null && time.length() == 6) {
                    char[] buffer = new char[8];
                    time.getChars(0, 2, buffer, 0);
                    buffer[2] = 58;
                    time.getChars(2, 4, buffer, 3);
                    buffer[5] = 58;
                    time.getChars(4, 6, buffer, 6);
                    return new String(buffer);
                }
                return time;
            }
            case 4: {
                return Codecs.Hex.encode(this.decodeBYTE(index));
            }
            case 29: {
                return this.decodeSTRING(index);
            }
            case 30: {
                return Codecs.Hex.encode(this.decodeXSTRING(index));
            }
            case 17: 
            case 99: {
                return this.metaData.name[index];
            }
        }
        throw this.createConversionException(index, "java.lang.String");
    }

    @Override
    public char getChar(int index) {
        switch (this.metaData.type[index]) {
            case 0: 
            case 6: {
                char[] temp_data;
                int len = this.metaData.blength[index];
                int i = this.metaData.blength[index] + this.metaData.boffset[index] - 1;
                char[] cArray = temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
                while (len > 1 && temp_data[i] == ' ') {
                    --len;
                    --i;
                }
                if (len == 1) {
                    return temp_data[this.metaData.boffset[index]];
                }
                throw this.createConversionException(index, "char");
            }
            case 29: {
                String value = this.decodeSTRING(index);
                if (value == null || value.length() == 0) {
                    return ' ';
                }
                if (value.length() == 1) {
                    return value.charAt(0);
                }
                throw this.createConversionException(index, "char");
            }
        }
        throw this.createConversionException(index, "char");
    }

    @Override
    public byte getByte(int index) {
        switch (this.metaData.type[index]) {
            case 0: 
            case 6: 
            case 29: {
                try {
                    char c = this.getChar(index);
                    byte b = (byte)c;
                    if (b == c) {
                        return b;
                    }
                }
                catch (ConversionException e) {}
                break;
            }
            case 4: {
                if (this.metaData.getByteLength(index) != 1) break;
                byte[] bytes = this.decodeBYTE(index);
                return bytes[0];
            }
            case 30: {
                byte[] bytes = this.decodeXSTRING(index);
                if (bytes.length != 1) break;
                return bytes[0];
            }
            case 8: 
            case 9: 
            case 10: {
                int valueInt = this.decodeINT(index);
                byte b = (byte)valueInt;
                if (valueInt != b) break;
                return b;
            }
        }
        throw this.createConversionException(index, "byte");
    }

    @Override
    public final byte getByte(String fieldName) {
        return this.getByte(this.metaData.indexOf(fieldName));
    }

    @Override
    public float getFloat(int index) {
        try {
            double value = this.getDouble(index);
            return (float)value;
        }
        catch (ConversionException e) {
            throw this.createConversionException(index, "float");
        }
    }

    @Override
    public final float getFloat(String fieldName) {
        return this.getFloat(this.metaData.indexOf(fieldName));
    }

    @Override
    public short getShort(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                int value = this.decodeINT(index);
                short casted_value = (short)value;
                if (casted_value != value) {
                    throw this.createConversionException(index, "short");
                }
                return casted_value;
            }
            case 4: {
                if (this.metaData.length[0][index] <= 2) {
                    byte[] b = this.decodeBYTE(index);
                    short byte_value = 0;
                    for (int i = 0; i < b.length; ++i) {
                        byte_value = (short)(byte_value << 8 | b[i] & 0xFF);
                    }
                    return byte_value;
                }
                throw this.createConversionException(index, "short");
            }
            case 2: {
                String str = this.decodeBCD(index);
                try {
                    return Short.parseShort(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "short");
                }
            }
            case 7: {
                double dval = this.decodeFLOAT(index);
                short ival = (short)dval;
                if ((double)ival == dval) {
                    return ival;
                }
                throw this.createConversionException(index, "short");
            }
            case 23: 
            case 24: {
                String str = this.decodeDecFloat(index).toPlainString();
                try {
                    return Short.parseShort(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "short");
                }
            }
            case 30: {
                byte[] b = this.decodeXSTRING(index);
                if (b == null) {
                    return 0;
                }
                if (b.length <= 2) {
                    short xstring_value = 0;
                    for (int i = 0; i < b.length; ++i) {
                        xstring_value = (short)(xstring_value << 8 | b[i] & 0xFF);
                    }
                    return xstring_value;
                }
                throw this.createConversionException(index, "short");
            }
            case 6: {
                try {
                    return Short.parseShort(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "short");
                }
            }
            case 0: {
                try {
                    return Short.parseShort(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "short");
                }
            }
            case 29: {
                try {
                    return Short.parseShort(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "short");
                }
            }
        }
        throw this.createConversionException(index, "short");
    }

    @Override
    public int getInt(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                return this.decodeINT(index);
            }
            case 4: {
                if (this.metaData.length[0][index] <= 4) {
                    byte[] b = this.decodeBYTE(index);
                    int byte_value = 0;
                    for (int i = 0; i < b.length; ++i) {
                        byte_value = byte_value << 8 | b[i] & 0xFF;
                    }
                    return byte_value;
                }
                throw this.createConversionException(index, "int");
            }
            case 2: {
                String str = this.decodeBCD(index);
                try {
                    return Integer.parseInt(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "int");
                }
            }
            case 7: {
                double dval = this.decodeFLOAT(index);
                int ival = (int)dval;
                if ((double)ival == dval) {
                    return ival;
                }
                throw this.createConversionException(index, "int");
            }
            case 23: 
            case 24: {
                String str = this.decodeDecFloat(index).toPlainString();
                try {
                    return Integer.parseInt(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "int");
                }
            }
            case 30: {
                byte[] b = this.decodeXSTRING(index);
                if (b == null) {
                    return 0;
                }
                if (b.length <= 4) {
                    int xstring_value = 0;
                    for (int i = 0; i < b.length; ++i) {
                        xstring_value = xstring_value << 8 | b[i] & 0xFF;
                    }
                    return xstring_value;
                }
                throw this.createConversionException(index, "int");
            }
            case 6: {
                try {
                    return Integer.parseInt(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "int");
                }
            }
            case 0: {
                try {
                    return Integer.parseInt(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "int");
                }
            }
            case 29: {
                try {
                    return Integer.parseInt(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "int");
                }
            }
        }
        throw this.createConversionException(index, "int");
    }

    @Override
    public long getLong(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                return this.decodeINT(index);
            }
            case 4: {
                if (this.metaData.length[0][index] <= 8) {
                    byte[] b = this.decodeBYTE(index);
                    long byte_value = 0L;
                    for (int i = 0; i < b.length; ++i) {
                        byte_value = byte_value << 8 | (long)b[i] & 0xFFL;
                    }
                    return byte_value;
                }
                throw this.createConversionException(index, "long");
            }
            case 2: {
                String str = this.decodeBCD(index);
                try {
                    return Long.parseLong(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "long");
                }
            }
            case 7: {
                double dval = this.decodeFLOAT(index);
                long ival = (long)dval;
                if ((double)ival == dval) {
                    return ival;
                }
                throw this.createConversionException(index, "long");
            }
            case 23: 
            case 24: {
                String str = this.decodeDecFloat(index).toPlainString();
                try {
                    return Long.parseLong(AbstractRecord.getIntegerNumber(str));
                }
                catch (NumberFormatException e) {
                    throw this.createConversionException(e, index, "long");
                }
            }
            case 30: {
                byte[] b = this.decodeXSTRING(index);
                if (b == null) {
                    return 0L;
                }
                if (b.length <= 8) {
                    long xstring_value = 0L;
                    for (int i = 0; i < b.length; ++i) {
                        xstring_value = xstring_value << 8 | (long)b[i] & 0xFFL;
                    }
                    return xstring_value;
                }
                throw this.createConversionException(index, "long");
            }
            case 6: {
                try {
                    return Long.parseLong(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "long");
                }
            }
            case 0: {
                try {
                    return Long.parseLong(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "long");
                }
            }
            case 29: {
                try {
                    return Long.parseLong(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "long");
                }
            }
        }
        throw this.createConversionException(index, "long");
    }

    @Override
    public BigInteger getBigInteger(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 6: {
                try {
                    return new BigInteger(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigInteger");
                }
            }
            case 8: 
            case 9: 
            case 10: {
                try {
                    return new BigInteger(Integer.toString(this.decodeINT(index)));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigInteger");
                }
            }
            case 2: {
                try {
                    return new BigInteger(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigInteger");
                }
            }
            case 23: 
            case 24: {
                return this.decodeDecFloat(index).toBigInteger();
            }
            case 0: {
                try {
                    return new BigInteger(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigInteger");
                }
            }
            case 29: {
                try {
                    return new BigInteger(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigInteger");
                }
            }
        }
        throw this.createConversionException(index, "java.math.BigInteger");
    }

    @Override
    public double getDouble(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 7: {
                return this.decodeFLOAT(index);
            }
            case 8: 
            case 9: 
            case 10: {
                return this.decodeINT(index);
            }
            case 6: {
                try {
                    return Double.valueOf(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "double");
                }
            }
            case 2: {
                try {
                    return Double.valueOf(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "double");
                }
            }
            case 23: 
            case 24: {
                return this.decodeDecFloat(index).doubleValue();
            }
            case 0: {
                try {
                    return Double.valueOf(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "double");
                }
            }
            case 29: {
                try {
                    return Double.valueOf(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "double");
                }
            }
        }
        throw this.createConversionException(index, "double");
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 7: {
                try {
                    BigDecimal bd = new BigDecimal(this.decodeFLOAT(index));
                    return bd.setScale((int)this.metaData.decimals[index], 6);
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 8: 
            case 9: 
            case 10: {
                try {
                    return new BigDecimal(this.decodeINT(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 6: {
                try {
                    return new BigDecimal(this.decodeNUM(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 2: {
                try {
                    return new BigDecimal(this.decodeBCD(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 0: {
                try {
                    return new BigDecimal(this.decodeNUMBER(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 29: {
                try {
                    return new BigDecimal(this.decodeSTRING(index));
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
            case 23: 
            case 24: {
                try {
                    return this.decodeDecFloat(index);
                }
                catch (NumberFormatException ex) {
                    throw this.createConversionException(index, "java.math.BigDecimal");
                }
            }
        }
        throw this.createConversionException(index, "java.math.BigDecimal");
    }

    @Override
    public Date getDate(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: 
            case 1: {
                return this.decodeDATE(index);
            }
            case 3: {
                return this.decodeTIME(index);
            }
        }
        throw this.createConversionException(index, "java.util.Date");
    }

    @Override
    public Date getTime(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: 
            case 3: {
                return this.decodeTIME(index);
            }
            case 1: {
                return this.decodeDATE(index);
            }
        }
        throw this.createConversionException(index, "java.util.Date");
    }

    @Override
    public byte[] getByteArray(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: {
                try {
                    return this.decodeCHAR(index).getBytes("UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw this.createConversionException(index, "byte[]");
                }
            }
            case 4: 
            case 23: 
            case 24: {
                return this.decodeBYTE(index);
            }
            case 29: {
                try {
                    return this.decodeSTRING(index).getBytes("UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw this.createConversionException(index, "byte[]");
                }
            }
            case 30: {
                return this.decodeXSTRING(index);
            }
        }
        throw this.createConversionException(index, "byte[]");
    }

    @Override
    public char[] getCharArray(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                return this.decodeCHARARRAY(index);
            }
            case 29: {
                String value = this.decodeSTRING(index);
                char[] result = new char[value.length()];
                value.getChars(0, value.length(), result, 0);
                return result;
            }
        }
        throw this.createConversionException(index, "char[]");
    }

    @Override
    public InputStream getBinaryStream(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 4: {
                return new ByteArrayInputStream(this.decodeBYTE(index));
            }
            case 30: {
                return new ByteArrayInputStream(this.decodeXSTRING(index));
            }
            case 0: {
                return new ByteArrayInputStream(this.decodeCHAR(index).getBytes());
            }
            case 29: {
                return new ByteArrayInputStream(this.decodeSTRING(index).getBytes());
            }
        }
        throw this.createConversionException(index, "java.io.InputStream");
    }

    @Override
    public Reader getCharacterStream(int index) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: {
                return new StringReader(this.decodeCHAR(index));
            }
            case 29: {
                return new StringReader(this.decodeSTRING(index));
            }
        }
        throw this.createConversionException(index, "java.io.Reader");
    }

    @Override
    public DefaultTable getTable(int index) {
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype == 99) {
            return this.decodeTABLE(index);
        }
        throw this.createConversionException(index, "TableRecord");
    }

    @Override
    public DefaultAbapObject getAbapObject(int index) {
        this.checkRowCapacity();
        if (this.metaData.type[index] == 16) {
            return this.decodeABAPOBJECT(index, false);
        }
        throw this.createConversionException(index, "AbapObject");
    }

    @Override
    public DefaultStructure getStructure(int index) {
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype == 17) {
            return this.decodeSTRUCTURE(index);
        }
        throw this.createConversionException(index, "StructureRecord");
    }

    @Override
    public String toXML(int index) {
        try {
            switch (this.metaData.type[index]) {
                case 17: {
                    return XMLWriter.createXMLDocument(this.decodeSTRUCTURE(index), this.metaData.name[index]);
                }
                case 99: {
                    return XMLWriter.createXMLDocument(this.decodeTABLE(index), this.metaData.name[index]);
                }
            }
            return new XMLWriter().element(this, index).toString();
        }
        catch (Exception ex) {
            throw this.createConversionException(index, "XML");
        }
    }

    @Override
    public String toXML(String fieldName) {
        return this.toXML(this.metaData.indexOf(fieldName));
    }

    @Override
    public String toXML() {
        return XMLWriter.createXMLDocument(this, this.metaData.recName);
    }

    public void fromXML(String xmlData) {
        XMLReader reader = new XMLReader(this);
        reader.parse(xmlData);
    }

    @Override
    public void setValue(int index, String value) {
        this.checkRowCapacity();
        if (value == null || value.length() == 0) {
            this.setDefault(index);
            return;
        }
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: {
                this.encodeCHAR(value, index);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                try {
                    this.encodeINT(Integer.parseInt(value), index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
                break;
            }
            case 7: {
                try {
                    Double dble = new Double(value.length() > 0 ? value : "0");
                    this.encodeFLOAT(dble, index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(value, index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
                break;
            }
            case 2: {
                this.encodeBCD(value.length() > 0 ? value : "0", index);
                break;
            }
            case 23: 
            case 24: {
                try {
                    this.encodeDecFloat(new BigDecimal(value), index);
                    break;
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                    break;
                }
                catch (RuntimeException ex) {
                    throw new ConversionException(new StringBuilder(200).append("Cannot convert a value of '").append(value).append("' from type java.lang.String to ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" at field ").append(this.metaData.name[index]).append(", caused by ").append(ex.toString()).toString());
                }
            }
            case 1: {
                try {
                    this.encodeDATE(value, index);
                }
                catch (Exception ex) {
                    conversion_error = true;
                }
                break;
            }
            case 3: {
                try {
                    this.encodeTIME(value, index);
                }
                catch (Exception ex) {
                    conversion_error = true;
                }
                break;
            }
            case 4: {
                try {
                    this.encodeBYTE(Codecs.Hex.decode(value), index);
                }
                catch (NumberFormatException ex) {
                    conversion_error = true;
                }
                break;
            }
            case 29: {
                this.encodeSTRING(value, index);
                break;
            }
            case 30: {
                this.encodeXSTRING(Codecs.Hex.decode(value), index);
                break;
            }
            default: {
                conversion_error = true;
            }
        }
        if (conversion_error) {
            throw this.createConversionException(index, "java.lang.String", value);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public final String getClassNameOfValue(String fieldName) {
        return this.metaData.getClassNameOfField(this.metaData.indexOf(fieldName));
    }

    @Override
    public final Object getValue(String fieldName) {
        return this.getValue(this.metaData.indexOf(fieldName));
    }

    @Override
    public final String getString(String fieldName) {
        return this.getString(this.metaData.indexOf(fieldName));
    }

    @Override
    public final char getChar(String fieldName) {
        return this.getChar(this.metaData.indexOf(fieldName));
    }

    @Override
    public final short getShort(String fieldName) {
        return this.getShort(this.metaData.indexOf(fieldName));
    }

    @Override
    public final int getInt(String fieldName) {
        return this.getInt(this.metaData.indexOf(fieldName));
    }

    @Override
    public final long getLong(String fieldName) {
        return this.getLong(this.metaData.indexOf(fieldName));
    }

    @Override
    public final BigInteger getBigInteger(String fieldName) {
        return this.getBigInteger(this.metaData.indexOf(fieldName));
    }

    @Override
    public final double getDouble(String fieldName) {
        return this.getDouble(this.metaData.indexOf(fieldName));
    }

    @Override
    public final BigDecimal getBigDecimal(String fieldName) {
        return this.getBigDecimal(this.metaData.indexOf(fieldName));
    }

    @Override
    public final Date getDate(String fieldName) {
        return this.getDate(this.metaData.indexOf(fieldName));
    }

    @Override
    public final Date getTime(String fieldName) {
        return this.getTime(this.metaData.indexOf(fieldName));
    }

    @Override
    public final byte[] getByteArray(String fieldName) {
        return this.getByteArray(this.metaData.indexOf(fieldName));
    }

    @Override
    public final char[] getCharArray(String fieldName) {
        return this.getCharArray(this.metaData.indexOf(fieldName));
    }

    @Override
    public final InputStream getBinaryStream(String fieldName) {
        return this.getBinaryStream(this.metaData.indexOf(fieldName));
    }

    @Override
    public final Reader getCharacterStream(String fieldName) {
        return this.getCharacterStream(this.metaData.indexOf(fieldName));
    }

    @Override
    public final DefaultTable getTable(String fieldName) {
        return this.getTable(this.metaData.indexOf(fieldName));
    }

    @Override
    public JCoAbapObject getAbapObject(String fieldName) {
        return this.getAbapObject(this.metaData.indexOf(fieldName));
    }

    @Override
    public final DefaultStructure getStructure(String fieldName) {
        return this.getStructure(this.metaData.indexOf(fieldName));
    }

    protected void setDefault(int index) {
        switch (this.metaData.type[index]) {
            case 0: {
                this.encodeCHAR("", index);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.encodeINT(0, index);
                break;
            }
            case 1: {
                this.encodeCHAR("00000000", index);
                break;
            }
            case 3: {
                this.encodeCHAR("000000", index);
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(0L, index);
                }
                catch (Exception exception) {}
                break;
            }
            case 7: {
                this.encodeFLOAT(0.0, index);
                break;
            }
            case 2: {
                this.encodeBCD("0", index);
                break;
            }
            case 23: {
                this.encodeBYTE(JCoRuntime.DECF16_ZERO, index);
                break;
            }
            case 24: {
                this.encodeBYTE(JCoRuntime.DECF34_ZERO, index);
                break;
            }
            case 4: {
                this.encodeBYTE(new byte[1], index);
                break;
            }
            case 29: {
                this.encodeSTRING("", index);
                break;
            }
            case 30: {
                this.encodeXSTRING(new byte[1], index);
                break;
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, char value) {
        switch (this.metaData.type[index]) {
            case 0: {
                this.encodeCHAR(value, index);
                break;
            }
            case 6: {
                this.encodeNUM(new char[]{value}, 0, 1, index);
                break;
            }
            case 29: {
                this.encodeSTRING(new String(new char[]{value}), index);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                int dig = value - 48;
                if (dig < 0 || dig > 9) {
                    throw this.createConversionException(index, "char", new String(new char[]{value}));
                }
                this.encodeINT(dig, index);
                break;
            }
            default: {
                throw this.createConversionException(index, "char", new String(new char[]{value}));
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, char[] value) {
        this.setValue(index, value, 0, value.length);
    }

    @Override
    public void setValue(int index, char[] value, int from, int length) {
        this.checkRowCapacity();
        if (value == null || length == 0) {
            this.setDefault(index);
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length [" + length + "] was passed. Current field " + this.metaData.name[index]);
        }
        if (value.length < from + length) {
            throw new IllegalArgumentException("Array length [" + value.length + "] less than length was passed [" + (from + length) + "]. Current field " + this.metaData.name[index]);
        }
        switch (this.metaData.type[index]) {
            case 0: {
                this.encodeCHARS(value, from, length, index);
                break;
            }
            case 6: {
                this.encodeNUM(value, from, length, index);
                break;
            }
            case 29: {
                this.encodeSTRING(new String(value, from, length), index);
                break;
            }
            case 3: {
                if (length != this.metaData.getLength(index)) {
                    try {
                        this.encodeTIME(new String(value, from, length), index);
                        break;
                    }
                    catch (Exception e) {
                        throw this.createConversionException(index, "char[]", new String(value, from, length));
                    }
                }
                this.encodeCHARS(value, from, length, index);
                break;
            }
            case 1: {
                if (length != this.metaData.getLength(index)) {
                    try {
                        this.encodeDATE(new String(value, from, length), index);
                        break;
                    }
                    catch (Exception e) {
                        throw this.createConversionException(index, "char[]", new String(value, from, length));
                    }
                }
                this.encodeCHARS(value, from, length, index);
                break;
            }
            default: {
                try {
                    this.setValue(index, new String(value, from, length));
                    break;
                }
                catch (ConversionException e) {
                    throw this.createConversionException(index, "char[]", new String(value, from, length));
                }
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, short value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                this.encodeINT(value, index);
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(value, index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 0: {
                this.encodeCHAR(Short.toString(value), index);
                break;
            }
            case 7: {
                this.encodeFLOAT(value, index);
                break;
            }
            case 2: {
                this.encodeBCD(Short.toString(value), index);
                break;
            }
            case 23: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            case 24: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL128), index);
                break;
            }
            case 29: {
                this.encodeSTRING(Short.toString(value), index);
                break;
            }
            case 30: {
                byte[] xstring = new byte[]{(byte)value};
                if (xstring[0] != value) {
                    throw this.createConversionException(index, "short", Short.toString(value));
                }
                this.encodeXSTRING(xstring, index);
                break;
            }
            case 4: {
                byte[] bytes = new byte[]{(byte)value};
                if (bytes[0] != value) {
                    throw this.createConversionException(index, "short", Short.toString(value));
                }
                this.encodeBYTE(bytes, index);
                break;
            }
            default: {
                throw this.createConversionException(index, "short", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, int value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                this.encodeINT(value, index);
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(value, index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 0: {
                this.encodeCHAR(Integer.toString(value), index);
                break;
            }
            case 7: {
                this.encodeFLOAT(value, index);
                break;
            }
            case 2: {
                this.encodeBCD(Integer.toString(value), index);
                break;
            }
            case 23: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            case 24: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL128), index);
                break;
            }
            case 29: {
                this.encodeSTRING(Integer.toString(value), index);
                break;
            }
            default: {
                throw this.createConversionException(index, "int", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, long value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 8: 
            case 9: 
            case 10: {
                int casted_value = (int)value;
                if ((long)casted_value != value) {
                    throw this.createConversionException(index, "long", null);
                }
                this.encodeINT(casted_value, index);
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(value, index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 0: {
                this.encodeCHAR(Long.toString(value), index);
                break;
            }
            case 7: {
                this.encodeFLOAT(value, index);
                break;
            }
            case 2: {
                this.encodeBCD(Long.toString(value), index);
                break;
            }
            case 23: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            case 24: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL128), index);
                break;
            }
            case 29: {
                this.encodeSTRING(Long.toString(value), index);
                break;
            }
            default: {
                throw this.createConversionException(index, "long", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, double value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 0: {
                this.encodeCHAR(Double.toString(value), index);
                break;
            }
            case 7: {
                this.encodeFLOAT(value, index);
                break;
            }
            case 2: {
                this.encodeBCD(this.dtoa(value, this.metaData.decimals[index]), index);
                break;
            }
            case 23: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            case 24: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL128), index);
                break;
            }
            case 29: {
                this.encodeSTRING(Double.toString(value), index);
                break;
            }
            default: {
                throw this.createConversionException(index, "double", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, BigDecimal value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 2: {
                try {
                    value = value.setScale((int)this.metaData.decimals[index], 6);
                    this.encodeBCD(value.toPlainString(), index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 7: {
                try {
                    value = value.setScale((int)this.metaData.decimals[index], 6);
                    this.setValue(index, value.doubleValue());
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 23: 
            case 24: {
                try {
                    this.encodeDecFloat(value, index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            default: {
                throw this.createConversionException(index, "java.math.BigDecimal", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, byte[] value) {
        this.checkRowCapacity();
        if (value == null || value.length == 0) {
            this.setDefault(index);
            return;
        }
        switch (this.metaData.type[index]) {
            case 4: {
                this.encodeBYTE(value, index);
                break;
            }
            case 30: {
                this.encodeXSTRING(value, index);
                break;
            }
            default: {
                throw this.createConversionException(index, "byte[]", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, JCoStructure value) {
        if (!(value instanceof DefaultStructure)) {
            throw new IllegalArgumentException("Only structures created by JCo are allowed");
        }
        DefaultStructure struct = (DefaultStructure)value;
        this.checkRowCapacity();
        if (this.metaData.type[index] != 17) {
            throw this.createConversionException(index, "JCoStructure", struct.metaData.getName());
        }
        this.encodeSTRUCTURE(struct, index);
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, JCoTable value) {
        if (!(value instanceof DefaultTable)) {
            throw new IllegalArgumentException("Only tables created by JCo are allowed");
        }
        DefaultTable table = (DefaultTable)value;
        this.checkRowCapacity();
        if (this.metaData.type[index] != 99) {
            throw this.createConversionException(index, "JCoTable", table.metaData.getName());
        }
        this.encodeTABLE(table, index);
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, Object value) {
        block19: {
            byte itype;
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                this.checkRowCapacity();
                                                if (value == null) {
                                                    this.setDefault(index);
                                                    return;
                                                }
                                                itype = this.metaData.type[index];
                                                if (!(value instanceof String)) break block18;
                                                this.setValue(index, (String)value);
                                                break block19;
                                            }
                                            if (!(value instanceof char[])) break block20;
                                            this.setValue(index, (char[])value);
                                            break block19;
                                        }
                                        if (!(value instanceof Integer)) break block21;
                                        this.setValue(index, (int)((Integer)value));
                                        break block19;
                                    }
                                    if (!(value instanceof Long)) break block22;
                                    this.setValue(index, (long)((Long)value));
                                    break block19;
                                }
                                if (!(value instanceof Short)) break block23;
                                this.setValue(index, ((Short)value).intValue());
                                break block19;
                            }
                            if (!(value instanceof Double)) break block24;
                            this.setValue(index, (double)((Double)value));
                            break block19;
                        }
                        if (!(value instanceof Float)) break block25;
                        this.setValue(index, ((Float)value).doubleValue());
                        break block19;
                    }
                    if (value instanceof BigInteger && itype == 6) {
                        try {
                            this.encodeNUM(value.toString(), index);
                        }
                        catch (Exception ex) {
                            throw new ConversionException(ex.getMessage(), ex);
                        }
                    }
                    if (!(value instanceof BigDecimal)) break block26;
                    this.setValue(index, (BigDecimal)value);
                    break block19;
                }
                if (!(value instanceof Date)) break block27;
                switch (itype) {
                    case 1: {
                        this.setValue(index, dateiso.format((Date)value));
                        break block19;
                    }
                    case 3: {
                        this.setValue(index, timeiso.format((Date)value));
                        break block19;
                    }
                    default: {
                        throw this.createConversionException(index, "java.lang.Object", null);
                    }
                }
            }
            if (value instanceof byte[] && itype == 4) {
                this.setValue(index, (byte[])value);
            } else if (value instanceof byte[] && itype == 30) {
                this.setValue(index, (byte[])value);
            } else if (value instanceof JCoStructure && itype == 17) {
                this.setValue(index, (JCoStructure)value);
            } else if (value instanceof JCoTable && itype == 99) {
                this.setValue(index, (JCoTable)value);
            } else if (value instanceof JCoAbapObject && itype == 16) {
                this.setValue(index, (JCoAbapObject)value);
            } else {
                throw this.createConversionException(index, "java.lang.Object", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(int index, JCoAbapObject abapObject) {
        if (!(abapObject instanceof DefaultAbapObject)) {
            throw new IllegalArgumentException("Only ABAP objects created by JCo are allowed");
        }
        DefaultAbapObject defaultAbapObject = (DefaultAbapObject)abapObject;
        this.checkRowCapacity();
        if (this.metaData.type[index] == 16) {
            int i;
            String childMetaDataClifName = this.metaData.getClassMetaData(index).getName();
            boolean assignable = false;
            DefaultClassMetaData defaultAbapObjectMetaData = (DefaultClassMetaData)defaultAbapObject.metaData;
            for (i = 0; i < defaultAbapObjectMetaData.parentClasses.size(); ++i) {
                if (!childMetaDataClifName.equals(defaultAbapObjectMetaData.parentClasses.get(i))) continue;
                assignable = true;
                break;
            }
            if (!assignable) {
                for (i = 0; i < defaultAbapObjectMetaData.implementedInterfaces.size(); ++i) {
                    if (!childMetaDataClifName.equals(defaultAbapObjectMetaData.implementedInterfaces.get(i))) continue;
                    assignable = true;
                    break;
                }
            }
            if (!assignable) {
                throw new ConversionException(new StringBuilder(200).append("Cannot assign an AbapObject instance of type ").append(defaultAbapObjectMetaData.getName()).append(" to the field ").append(this.metaData.name[index]).append(" allowing type ").append(childMetaDataClifName).toString());
            }
        } else {
            throw this.createConversionException(index, "JCoAbapObject", defaultAbapObject.metaData.getName());
        }
        this.encodeABAPOBJECT(defaultAbapObject, index);
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(String name, String value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, char[] value) {
        this.setValue(this.metaData.indexOf(name), value, 0, value.length);
    }

    @Override
    public void setValue(String name, char[] value, int from, int length) {
        this.setValue(this.metaData.indexOf(name), value, from, length);
    }

    @Override
    public void setValue(String name, char value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, short value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, int value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, long value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, double value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(int index, float value) {
        this.setValue(index, (double)value);
    }

    @Override
    public void setValue(String name, float value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, BigDecimal value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(int index, byte value) {
        this.checkRowCapacity();
        switch (this.metaData.type[index]) {
            case 4: {
                if (this.metaData.getByteLength(index) > 1) {
                    throw new ConversionException("This is not a proper method to set the field " + this.metaData.name[index] + ", since this field is longer then 1 byte. Use a different method.");
                }
                byte[] b = new byte[]{value};
                this.encodeBYTE(b, index);
                break;
            }
            case 30: {
                byte[] b_x = new byte[]{value};
                this.encodeXSTRING(b_x, index);
                break;
            }
            case 0: {
                if (this.metaData.getUnicodeByteLength(index) > 1) {
                    throw new ConversionException("This is not a proper method to set the field " + this.metaData.name[index] + ", since this field is longer then 1 byte. Use a different method.");
                }
                this.encodeCHAR((char)value, index);
                break;
            }
            case 29: {
                char[] c = new char[]{(char)value};
                this.encodeSTRING(new String(c), index);
                break;
            }
            case 9: 
            case 10: {
                this.encodeINT(value, index);
                break;
            }
            case 6: {
                try {
                    this.encodeNUM(value, index);
                    break;
                }
                catch (Exception ex) {
                    throw new ConversionException(ex.getMessage(), ex);
                }
            }
            case 2: {
                this.encodeBCD(Byte.toString(value), index);
                break;
            }
            case 23: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            case 24: {
                this.encodeDecFloat(new BigDecimal(value, MathContext.DECIMAL64), index);
                break;
            }
            default: {
                throw this.createConversionException(index, "byte", null);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    @Override
    public void setValue(String name, byte value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, byte[] value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, JCoStructure value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, JCoTable value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String name, Object value) {
        this.setValue(this.metaData.indexOf(name), value);
    }

    @Override
    public void setValue(String fieldName, JCoAbapObject abapObject) {
        this.setValue(this.metaData.indexOf(fieldName), abapObject);
    }

    @Override
    public boolean isInitialized(int index) {
        return (this.flags[index] & 1) == 0;
    }

    @Override
    public boolean isInitialized(String field_name) {
        return (this.flags[this.metaData.indexOf(field_name)] & 1) == 0;
    }

    private final void encodeCHAR(String value, int index) {
        if (value == null) {
            value = "";
        }
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        ilength = Math.min(value.length(), ilength);
        value.getChars(0, ilength, temp_data, ioffset);
        ioffset += ilength;
        while (ioffset < iend) {
            temp_data[ioffset++] = 32;
        }
    }

    private final void encodeCHAR(char value, int index) {
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        temp_data[ioffset] = value;
        ++ioffset;
        while (ioffset < iend) {
            temp_data[ioffset++] = 32;
        }
    }

    private final void encodeCHARS(char[] value, int from, int length, int index) {
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        ilength = Math.min(length, ilength);
        System.arraycopy(value, from, temp_data, ioffset, ilength);
        ioffset += ilength;
        while (ioffset < iend) {
            temp_data[ioffset++] = 32;
        }
    }

    private final void encodeINT(int value, int index) {
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int iend = ioffset + this.metaData.blength[index];
        byte itype = this.metaData.type[index];
        if (itype == 10) {
            if (value < 0 || value > 255) {
                throw this.createConversionException(index, "int", Integer.toString(value));
            }
            temp_data[ioffset] = (char)((value & 0xFF) << 8);
        } else if (itype == 9) {
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw this.createConversionException(index, "int", Integer.toString(value));
            }
            temp_data[ioffset] = (char)value;
        } else {
            while (iend > ioffset) {
                temp_data[--iend] = (char)(value & 0xFFFF);
                value >>= 16;
            }
        }
    }

    private final void encodeFLOAT(double dvalue, int index) {
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int iend = ioffset + this.metaData.blength[index];
        long value = Double.doubleToLongBits(dvalue);
        while (iend > ioffset) {
            temp_data[--iend] = (char)(value & 0xFFFFL);
            value >>= 16;
        }
    }

    private final void encodeNUM(long value, int index) {
        int i;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int length = 0;
        if (value < 0L) {
            throw new ConversionException("Value '" + value + "' cannot be converted to " + AbstractMetaData.getJCOTypeString(this.metaData.type[index]) + " type at field " + this.metaData.name[index]);
        }
        for (long tmp_value = value; tmp_value > 0L; tmp_value /= 10L) {
            ++length;
        }
        if (length > ilength) {
            throw new ConversionException("Integer '" + value + "' has to many digits at field " + this.metaData.name[index]);
        }
        for (i = 0; i < ilength - length; ++i) {
            temp_data[ioffset++] = 48;
        }
        i = ilength - 1;
        ioffset += length;
        while (i >= ilength - length) {
            temp_data[--ioffset] = (char)(48L + value % 10L);
            --i;
            value /= 10L;
        }
    }

    private final void encodeNUM(String value, int index) {
        int i;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int length = 0;
        int start = 0;
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (length == 0 && c == '0') {
                ++start;
                continue;
            }
            if (c >= '0' && c <= '9') {
                ++length;
                continue;
            }
            throw new ConversionException("Value '" + value + "' cannot be converted to " + AbstractMetaData.getJCOTypeString(this.metaData.type[index]) + " type at field " + this.metaData.name[index]);
        }
        if (length > ilength) {
            throw new ConversionException("Integer '" + value + "' has to many digits at field " + this.metaData.name[index]);
        }
        for (i = 0; i < ilength - length; ++i) {
            temp_data[ioffset++] = 48;
        }
        for (i = 0; i < length; ++i) {
            temp_data[ioffset++] = value.charAt(start + i);
        }
    }

    private final void encodeNUM(char[] value, int offset, int length, int index) {
        int i;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int start = offset;
        int end = start + length;
        for (i = start; i < end; ++i) {
            if (i == start && value[i] == '0') {
                ++start;
                continue;
            }
            if (value[i] >= '0' && value[i] <= '9') continue;
            throw new ConversionException("Value char[] {" + new String(value) + "} cannot be converted to " + AbstractMetaData.getJCOTypeString(this.metaData.type[index]) + " type at field " + this.metaData.name[index]);
        }
        if (end - start > ilength) {
            throw new ConversionException("Integer '" + new String(value) + "' has to many digits at field " + this.metaData.name[index]);
        }
        for (i = offset; i < start; ++i) {
            temp_data[ioffset++] = 48;
        }
        for (i = start; i < end; ++i) {
            temp_data[ioffset++] = value[i];
        }
    }

    private final void encodeBCD(CharSequence svalue, int index) {
        int digit;
        int dot;
        char c;
        int firstChar;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int iend = ioffset + this.metaData.blength[index];
        int ilength = this.metaData.length[0][index] * 2 - 1;
        byte ldecimals = this.metaData.decimals[index];
        for (int i = ioffset; i < iend; ++i) {
            temp_data[i] = '\u0000';
        }
        int n = ioffset + (ilength >> 2);
        temp_data[n] = (char)(temp_data[n] | 12 << (3 - (ilength & 3) << 2));
        int lastChar = svalue.length() - 1;
        for (firstChar = 0; firstChar <= lastChar && (c = svalue.charAt(firstChar)) == ' '; ++firstChar) {
        }
        while (firstChar <= lastChar && (c = svalue.charAt(firstChar)) == '0') {
            ++firstChar;
        }
        while (firstChar <= lastChar && (c = svalue.charAt(lastChar)) == ' ') {
            --lastChar;
        }
        if (firstChar > lastChar) {
            return;
        }
        boolean signNegativ = false;
        c = svalue.charAt(firstChar);
        if (c == '-') {
            signNegativ = true;
            ++firstChar;
        } else if (c == '+') {
            ++firstChar;
        }
        while (firstChar <= lastChar && (c = svalue.charAt(firstChar)) == '0') {
            ++firstChar;
        }
        if (firstChar > lastChar) {
            return;
        }
        for (dot = firstChar; dot <= lastChar && (c = svalue.charAt(dot)) != '.'; ++dot) {
        }
        while (dot <= lastChar && (c = svalue.charAt(lastChar)) == '0') {
            --lastChar;
        }
        int lfraction = lastChar - dot;
        int lradix = dot - firstChar;
        if (lradix > ilength - ldecimals || lfraction > ldecimals) {
            throw new ConversionException("Number " + svalue + " cannot be encoded as a BCD of length " + ilength + " with " + ldecimals + " decimal places at field " + this.metaData.name[index]);
        }
        if (signNegativ) {
            int n2 = ioffset + (ilength >> 2);
            temp_data[n2] = (char)(temp_data[n2] | 13 << (3 - (ilength & 3) << 2));
        } else {
            int n3 = ioffset + (ilength >> 2);
            temp_data[n3] = (char)(temp_data[n3] | 12 << (3 - (ilength & 3) << 2));
        }
        int k = ilength - lradix - ldecimals;
        while (firstChar < dot) {
            digit = svalue.charAt(firstChar) - 48;
            if (digit < 0 || digit > 9) {
                throw new ConversionException("Number " + svalue + " cannot be encoded as a BCD. Invalid digit '" + firstChar + "' encountered");
            }
            int n4 = ioffset + (k >> 2);
            temp_data[n4] = (char)(temp_data[n4] | (digit & 0xF) << (3 - (k & 3) << 2));
            ++k;
            ++firstChar;
        }
        firstChar = dot + 1;
        while (firstChar <= lastChar) {
            digit = svalue.charAt(firstChar) - 48;
            if (digit < 0 || digit > 9) {
                throw new ConversionException("Number " + svalue + " cannot be encoded as a BCD. Invalid digit '" + firstChar + "' encountered");
            }
            int n5 = ioffset + (k >> 2);
            temp_data[n5] = (char)(temp_data[n5] | (digit & 0xF) << (3 - (k & 3) << 2));
            ++firstChar;
            ++k;
        }
    }

    private final void encodeBYTE(byte[] value, int index) {
        int i;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        for (i = ioffset; i < iend; ++i) {
            temp_data[i] = '\u0000';
        }
        ilength = Math.min(ilength * 2, value.length);
        for (i = 0; i < ilength; ++i) {
            int n = ioffset + (i >> 1);
            temp_data[n] = (char)(temp_data[n] | (char)((value[i] & 0xFF) << (1 - (i & 1) << 3)));
        }
    }

    private final void encodeTIME(String value, int index) throws ParseException {
        String time = value;
        if (value.equals("240000") || value.equals("24:00:00") || value.equals("  :  :  ")) {
            time = "240000";
        } else {
            try {
                time = timerfc.format(timeiso.parse(value));
            }
            catch (ParseException ex) {
                time = timerfc.format(timerfc.parse(value));
            }
        }
        this.encodeCHAR(time, index);
    }

    private final void encodeDATE(String value, int index) throws ParseException {
        String date = value;
        if (value.length() == 0 || value.equals("0000-00-00") || value.equals("00000000") || value.equals("    -  -  ")) {
            date = "00000000";
        } else if (value.equals("9999-99-99") || value.equals("99999999")) {
            date = "99999999";
        } else {
            try {
                date = daterfc.format(dateiso.parse(value));
            }
            catch (ParseException ex) {
                date = daterfc.format(daterfc.parse(value));
            }
        }
        this.encodeCHAR(date, index);
    }

    private final void encodeSTRING(String value, int index) {
        this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = value;
    }

    private final void encodeDecFloat(BigDecimal bd, int index) {
        int length = this.metaData.length[0][index];
        byte[] value = new byte[length];
        DecFloatType type = length == 8 ? DecFloatType.DECFLOAT16_BE : DecFloatType.DECFLOAT34_BE;
        DecFloat.fromBigDecimal(type, bd, value, 0, length);
        this.encodeBYTE(value, index);
    }

    private final void encodeXSTRING(byte[] value, int index) {
        this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = value;
    }

    private final void encodeSTRUCTURE(DefaultStructure value, int index) {
        this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = value;
        value.ensureBufferCapacity();
    }

    private final void encodeTABLE(DefaultTable value, int index) {
        this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = value;
        value.ensureBufferCapacity();
    }

    private final void encodeABAPOBJECT(DefaultAbapObject value, int index) {
        this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = value;
        value.ensureBufferCapacity();
    }

    final void encodeBINARY(byte[] value, int voffset, int vlength, int index) {
        char[] temp_data = null;
        byte itype = this.metaData.type[index];
        if (this.rowLength > 0) {
            temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        }
        switch (itype) {
            case 30: {
                byte[] bytes = new byte[vlength];
                System.arraycopy(value, voffset, bytes, 0, vlength);
                this.encodeXSTRING(bytes, index);
                break;
            }
            case 4: {
                int ioffset = this.metaData.boffset[index];
                int ilength = 2 * this.metaData.blength[index];
                int iend = ioffset + this.metaData.blength[index];
                for (int i = ioffset; i < iend; ++i) {
                    temp_data[i] = '\u0000';
                }
                if (vlength > ilength) {
                    vlength = ilength;
                }
                for (int k = 0; k < vlength; ++k) {
                    int n = ioffset + (k >> 1);
                    temp_data[n] = (char)(temp_data[n] | (char)((value[voffset + k] & 0xFF) << (1 - (k & 1) << 3)));
                }
                break;
            }
            default: {
                throw new ConversionException("datatype  '" + AbstractMetaData.getJCOTypeString(itype) + "' cannot be used for storing data with encodeBINARY in field " + this.metaData.name[index]);
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    protected final void encodeGENERIC(char[] value, int voffset, int vlength, int index) {
        char[] temp_data = null;
        byte itype = this.metaData.type[index];
        if (this.rowLength > 0) {
            temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        }
        switch (itype) {
            case 0: {
                int ioffset = this.metaData.boffset[index];
                int ilength = this.metaData.blength[index];
                ilength = Math.min(vlength, ilength);
                System.arraycopy(value, voffset, temp_data, ioffset, ilength);
                break;
            }
            case 6: {
                int i;
                int ioffset = this.metaData.boffset[index];
                int ilength = this.metaData.blength[index];
                if (vlength > ilength) {
                    if (index == this.metaData.numFields - 1) {
                        System.arraycopy(value, vlength - ilength, value, 0, vlength);
                        vlength = ilength;
                    } else {
                        throw new ConversionException("Integer '" + new String(value, voffset, vlength) + "' has to many digits at field " + this.metaData.name[index]);
                    }
                }
                for (i = 0; i < ilength - vlength; ++i) {
                    temp_data[ioffset++] = 48;
                }
                for (i = 0; i < vlength; ++i) {
                    temp_data[ioffset++] = value[voffset++];
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                try {
                    this.encodeINT(Integer.parseInt(new String(value, voffset, vlength)), index);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new ConversionException("Integer '" + new String(value, voffset, vlength) + "' has a wrong format at field " + this.metaData.name[index] + ": " + ex.getMessage(), ex);
                }
            }
            case 7: {
                try {
                    this.encodeFLOAT(Double.parseDouble(new String(value, voffset, vlength)), index);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new ConversionException("Float '" + new String(value, voffset, vlength) + "' has a wrong format at field " + this.metaData.name[index] + ": " + ex.getMessage(), ex);
                }
            }
            case 2: {
                this.encodeBCD(new String(value, voffset, vlength), index);
                break;
            }
            case 1: {
                try {
                    this.encodeDATE(new String(value, voffset, vlength), index);
                    break;
                }
                catch (Exception e) {
                    throw new ConversionException("Date '" + new String(value, voffset, vlength) + "' has a wrong format at field " + this.metaData.name[index] + ": " + e.getMessage(), e);
                }
            }
            case 3: {
                try {
                    this.encodeTIME(new String(value, voffset, vlength), index);
                    break;
                }
                catch (Exception e) {
                    throw new ConversionException("Time '" + new String(value, voffset, vlength) + "' has a wrong format at field " + this.metaData.name[index] + ": " + e.getMessage(), e);
                }
            }
            case 23: 
            case 24: {
                int length = this.metaData.length[0][index];
                byte[] tmp = new byte[length];
                DecFloatType type = length == 8 ? DecFloatType.DECFLOAT16_BE : DecFloatType.DECFLOAT34_BE;
                DecFloat.fromString(type, new String(value, voffset, vlength), tmp, 0, length);
                this.encodeBYTE(tmp, index);
                break;
            }
            case 29: {
                this.encodeSTRING(new String(value, voffset, vlength), index);
                break;
            }
            case 30: {
                byte[] bytes = Codecs.Base64.decode(value, voffset, vlength);
                this.encodeXSTRING(bytes, index);
                break;
            }
            case 4: {
                byte[] bytes = Codecs.Base64.decode(value, voffset, vlength);
                this.encodeBYTE(bytes, index);
                break;
            }
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    final String decodeHEX(int index) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int ioffset = this.metaData.boffset[index];
        int ilength = Math.max(this.metaData.length[0][index], 2 * this.metaData.blength[index]);
        StringBuilder buf = new StringBuilder();
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        for (int i = 0; i < ilength; ++i) {
            byte value = (byte)(temp_data[ioffset + (i >> 1)] >> (1 - (i & 1) << 3) & 0xFF);
            buf.append(hex[value >> 4 & 0xF]);
            buf.append(hex[value >> 0 & 0xF]);
        }
        return buf.toString();
    }

    private final String decodeCHAR(int index) {
        int iend;
        char[] temp_data;
        int ioffset = this.metaData.boffset[index];
        char[] cArray = temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        for (iend = ioffset + this.metaData.blength[index] - 1; iend >= ioffset && temp_data[iend] == ' '; --iend) {
        }
        int len = iend - ioffset + 1;
        return len == 0 ? "" : new String(temp_data, ioffset, len);
    }

    private final char[] decodeCHARARRAY(int index) {
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        char[] result = new char[ilength];
        System.arraycopy(temp_data, ioffset, result, 0, ilength);
        return result;
    }

    private final int decodeINT(int index) {
        char[] temp_data;
        int ioffset = this.metaData.boffset[index];
        int iend = ioffset + this.metaData.blength[index];
        byte itype = this.metaData.type[index];
        int value = 0;
        char[] cArray = temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        if (itype == 10) {
            value = temp_data[ioffset] >> 8;
        } else if (itype == 9) {
            value = (short)temp_data[ioffset];
        } else {
            while (ioffset < iend) {
                value = value << 16 | temp_data[ioffset++];
            }
        }
        return value;
    }

    private final double decodeFLOAT(int index) {
        char[] temp_data;
        int ioffset = this.metaData.boffset[index];
        int iend = ioffset + this.metaData.blength[index];
        long value = 0L;
        char[] cArray = temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        while (ioffset < iend) {
            value = value << 16 | (long)temp_data[ioffset++];
        }
        return Double.longBitsToDouble(value);
    }

    private final Date decodeDATE(int index) {
        String str = this.decodeCHAR(index);
        if (str.length() == 0 || str.equals("00000000") || str.equals("0000-00-00")) {
            return null;
        }
        if (str.equals("99999999") || str.equals("9999-99-99")) {
            str = "99991231";
        }
        try {
            return daterfc.parse(str);
        }
        catch (Exception ex) {
            try {
                return dateiso.parse(str);
            }
            catch (Exception ex2) {
                throw new ConversionException(ex2.getMessage() + " in record " + this.metaData.recName + " at field " + this.metaData.name[index], ex2);
            }
        }
    }

    private final Date decodeTIME(int index) {
        String str = this.decodeCHAR(index);
        if (str.length() == 0) {
            return null;
        }
        if (str.equals("240000") || str.equals("24:00:00")) {
            str = "000000";
        }
        try {
            return timerfc.parse(str);
        }
        catch (Exception ex) {
            try {
                return timeiso.parse(str);
            }
            catch (Exception ex2) {
                throw new ConversionException(ex2.getMessage() + " in record " + this.metaData.recName + " at field " + this.metaData.name[index], ex2);
            }
        }
    }

    private final String decodeNUM(int index) {
        return this.decodeCHAR(index);
    }

    private final String decodeNUMBER(int index) {
        char[] temp_data;
        int ioffset;
        int iend = ioffset + this.metaData.blength[index] - 1;
        char[] cArray = temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        for (ioffset = this.metaData.boffset[index]; ioffset <= iend && temp_data[ioffset] == ' '; ++ioffset) {
        }
        while (iend >= ioffset && temp_data[iend] == ' ') {
            --iend;
        }
        if (ioffset > iend) {
            return "0";
        }
        if (temp_data[iend] == '-') {
            StringBuilder value = new StringBuilder(iend - ioffset + 1);
            value.append('-');
            value.append(temp_data, ioffset, iend - ioffset);
            return value.toString();
        }
        if (temp_data[iend] == '+' && temp_data[ioffset] != '-' && temp_data[ioffset] != '+') {
            --iend;
        }
        return new String(temp_data, ioffset, iend - ioffset + 1);
    }

    private final String decodeBCD(int index) {
        int i;
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        byte idecimals = this.metaData.decimals[index];
        int ilength = this.metaData.length[0][index] * 2 - 1;
        int lradix = ilength - idecimals;
        StringBuilder buf = new StringBuilder(ilength + 2);
        int nibbleValue = 0;
        int signNibble = temp_data[ioffset + (ilength >> 2)] >> (3 - (ilength & 3) << 2) & 0xF;
        if (signNibble != 12 && signNibble != 13) {
            throw new ConversionException("Incorrectly encoded sign for BCD in record " + this.metaData.recName + " at field " + this.metaData.name[index]);
        }
        for (i = 0; i < ilength && (nibbleValue = temp_data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF) == 0; ++i) {
        }
        if (nibbleValue != 0 && signNibble == 13) {
            buf.append('-');
        }
        if (i >= lradix) {
            buf.append('0');
        } else {
            while (i < lradix) {
                nibbleValue = temp_data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF;
                buf.append((char)(48 + nibbleValue));
                ++i;
            }
        }
        if (idecimals <= 0) {
            return buf.toString();
        }
        buf.append('.');
        for (i = lradix; i < ilength; ++i) {
            nibbleValue = temp_data[ioffset + (i >> 2)] >> (3 - (i & 3) << 2) & 0xF;
            buf.append((char)(48 + nibbleValue));
        }
        return buf.toString();
    }

    private final byte[] decodeBYTE(int index) {
        char[] temp_data = this.recType == 4 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.length[0][index];
        byte[] value = new byte[ilength];
        for (int i = 0; i < ilength; ++i) {
            value[i] = (byte)(temp_data[ioffset + (i >> 1)] >> (1 - (i & 1) << 3) & 0xFF);
        }
        return value;
    }

    private final String decodeSTRING(int index) {
        return (String)this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]];
    }

    private final BigDecimal decodeDecFloat(int index) {
        byte[] bytes = this.decodeBYTE(index);
        DecFloatType type = bytes.length == 8 ? DecFloatType.DECFLOAT16_BE : DecFloatType.DECFLOAT34_BE;
        return DecFloat.toBigDecimal(type, bytes, 0, bytes.length);
    }

    private final byte[] decodeXSTRING(int index) {
        return (byte[])this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]];
    }

    private final DefaultStructure decodeSTRUCTURE(int index) {
        return (DefaultStructure)this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]];
    }

    private final DefaultTable decodeTABLE(int index) {
        DefaultTable t = (DefaultTable)this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]];
        if (t != null) {
            t.firstRow();
        }
        return t;
    }

    private final DefaultAbapObject decodeABAPOBJECT(int index, boolean create) {
        JCoClassMetaData classMetaData;
        DefaultAbapObject ao = (DefaultAbapObject)this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]];
        if (ao == null && create && (classMetaData = this.metaData.getClassMetaData(index)) != null) {
            ao = new DefaultAbapObject(classMetaData);
            this.odata[this.row * this.metaData.numOdata + this.metaData.oindex[index]] = ao;
        }
        return ao;
    }

    private String dtoa(double d, int decimals) {
        int i;
        StringBuilder buf = new StringBuilder();
        boolean sign = false;
        if (d < 0.0) {
            sign = true;
            d *= -1.0;
        }
        for (i = 0; i < decimals; ++i) {
            d *= 10.0;
        }
        long digits = (long)(d += 0.5);
        if (digits == 0L) {
            return "0";
        }
        buf.append(String.valueOf(digits));
        i = buf.length();
        if (i <= decimals) {
            buf.insert(0, "0.");
            i = decimals - i;
            while (--i >= 0) {
                buf.insert(2, '0');
            }
        } else {
            buf.insert(buf.length() - decimals, '.');
        }
        i = buf.length();
        while (--i >= 0 && buf.charAt(i) == '0') {
        }
        if (buf.charAt(i) != '.') {
            ++i;
        }
        buf.delete(i, buf.length());
        if (sign) {
            buf.insert(0, '-');
        }
        return buf.toString();
    }

    private static String getIntegerNumber(String decimalNumber) throws NumberFormatException {
        int dot = decimalNumber.indexOf(46);
        if (dot < 0) {
            dot = decimalNumber.length();
        } else {
            for (int i = dot + 1; i < decimalNumber.length(); ++i) {
                if (decimalNumber.charAt(i) == '0') continue;
                throw new NumberFormatException("fraction part is not zero: " + decimalNumber);
            }
        }
        return decimalNumber.substring(0, dot);
    }

    public String toString() {
        int i;
        int length;
        int index;
        StringBuilder buf = new StringBuilder(200);
        int ilength = 0;
        int row_save = this.row;
        buf.append('|');
        for (index = 0; index < this.metaData.numFields; ++index) {
            switch (this.metaData.type[index]) {
                case 99: {
                    if (this.metaData.name[index].length() == 0) {
                        length = ((DefaultRecordMetaData)this.metaData).typeName.length();
                        for (i = 0; i < length; ++i) {
                            buf.append('-');
                        }
                        break;
                    }
                }
                case 16: 
                case 17: 
                case 29: 
                case 30: {
                    length = this.metaData.name[index].length();
                    for (i = 0; i < length; ++i) {
                        buf.append('-');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 23: 
                case 24: {
                    for (i = 0; i < this.metaData.blength[index]; ++i) {
                        buf.append("----");
                    }
                    break;
                }
                default: {
                    for (i = 0; i < this.metaData.blength[index]; ++i) {
                        buf.append('-');
                    }
                }
            }
            buf.append('|');
        }
        String lineString = buf.toString();
        buf.append(JCoRuntime.CRLF);
        switch (this.recType) {
            case 4: {
                buf.append("| TABLE");
                break;
            }
            case 2: {
                buf.append("| STRUCTURE");
                break;
            }
            case 16: {
                buf.append("| REQUEST");
                break;
            }
            case 32: {
                buf.append("| RESPONSE");
                break;
            }
            case 1: {
                buf.append("| PARAMETERS");
                break;
            }
            case 64: {
                buf.append("| ABAPOBJECT");
            }
        }
        buf.append(" '");
        buf.append(this.metaData.recName);
        buf.append("'");
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        for (index = 0; index < this.metaData.numFields; ++index) {
            String iname = this.metaData.name[index];
            switch (this.metaData.type[index]) {
                case 99: {
                    if (iname.length() == 0) {
                        iname = ((DefaultRecordMetaData)this.metaData).typeName;
                    }
                }
                case 16: 
                case 17: 
                case 29: 
                case 30: {
                    ilength = iname.length();
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 23: 
                case 24: {
                    ilength = this.metaData.blength[index] * 4;
                    break;
                }
                default: {
                    ilength = this.metaData.blength[index];
                }
            }
            if (iname.length() > ilength) {
                iname = iname.substring(0, ilength);
            }
            buf.append("|");
            buf.append(iname);
            length = ilength;
            for (i = iname.length(); i < length; ++i) {
                buf.append(' ');
            }
        }
        buf.append("|" + JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        buf.append('|');
        for (index = 0; index < this.metaData.numFields; ++index) {
            switch (this.metaData.type[index]) {
                case 99: {
                    if (this.metaData.name[index].length() == 0) {
                        length = ((DefaultRecordMetaData)this.metaData).typeName.length();
                        for (i = 0; i < length; ++i) {
                            buf.append(' ');
                        }
                        break;
                    }
                }
                case 16: 
                case 17: 
                case 29: 
                case 30: {
                    length = this.metaData.name[index].length();
                    for (i = 0; i < length; ++i) {
                        buf.append(' ');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 23: 
                case 24: {
                    length = this.metaData.boffset[index] + this.metaData.blength[index];
                    for (i = this.metaData.boffset[index]; i < length; ++i) {
                        buf.append("   ");
                        buf.append(i % 10);
                    }
                    break;
                }
                default: {
                    length = this.metaData.boffset[index] + this.metaData.blength[index];
                    for (i = this.metaData.boffset[index]; i < length; ++i) {
                        buf.append(i % 10);
                    }
                }
            }
            buf.append('|');
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        if (this.numRows > 0) {
            char[] tmpData = null;
            this.row = 0;
            while (this.row < this.numRows) {
                tmpData = this.recType == 4 && this.tableDataRows != null ? this.tableDataRows[this.row] : this.data;
                buf.append('|');
                for (int index2 = 0; index2 < this.metaData.numFields; ++index2) {
                    switch (this.metaData.type[index2]) {
                        case 17: {
                            buf.append(this.metaData.name[index2]);
                            break;
                        }
                        case 99: {
                            buf.append(this.metaData.name[index2].length() > 0 ? this.metaData.name[index2] : ((DefaultRecordMetaData)this.metaData).typeName);
                            break;
                        }
                        case 16: {
                            DefaultAbapObject object = this.getAbapObject(index2);
                            if (object == null) {
                                buf.append("null");
                                for (int i2 = 4; i2 < this.metaData.name[index2].length(); ++i2) {
                                    buf.append(' ');
                                }
                                break;
                            }
                            buf.append(this.metaData.name[index2]);
                            break;
                        }
                        case 29: 
                        case 30: {
                            try {
                                String temp = this.getString(index2);
                                ilength = this.metaData.name[index2].length();
                                if (temp == null) {
                                    temp = "null";
                                }
                                if (temp.length() > ilength) {
                                    temp = temp.substring(0, ilength);
                                }
                                buf.append(temp);
                                for (int i3 = temp.length(); i3 < ilength; ++i3) {
                                    buf.append(' ');
                                }
                                break;
                            }
                            catch (ConversionException ex) {
                                break;
                            }
                        }
                        case 2: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 23: 
                        case 24: {
                            buf.append(this.decodeHEX(index2));
                            break;
                        }
                        default: {
                            buf.append(tmpData, this.metaData.boffset[index2], this.metaData.blength[index2]);
                        }
                    }
                    buf.append('|');
                }
                if (this.row < this.numRows - 1) {
                    buf.append(JCoRuntime.CRLF);
                }
                ++this.row;
            }
        }
        buf.append(JCoRuntime.CRLF);
        buf.append(lineString);
        buf.append(JCoRuntime.CRLF);
        this.row = row_save;
        return buf.toString();
    }

    public void readXML(Reader reader) throws IOException, XMLParserException {
        XMLReader.readXMLDocument(this, reader);
    }

    public void writeXML(Writer writer) throws IOException {
        this.writeXML(writer, "urn:sap-com:document:sap:rfc:functions", true);
    }

    public void writeXML(Writer writer, boolean with_header) throws IOException {
        this.writeXML(writer, "urn:sap-com:document:sap:rfc:functions", with_header);
    }

    public void writeXML(Writer writer, String namespace_urn, boolean with_header) throws IOException {
        XMLWriter w = new XMLWriter(writer);
        if (with_header) {
            w.prolog();
        }
        w.encode(this, this.metaData.recName + (this.recType == 32 ? ".Response" : ""), "rfc", namespace_urn).flush();
        writer.flush();
    }

    @Override
    public Iterator<JCoField> iterator() {
        return new DefaultFieldIterator(this);
    }

    @Override
    public JCoFieldIterator getFieldIterator() {
        return new DefaultFieldIterator(this);
    }
}

